import QtQuick 1.0

Item {
    id: container
    width: 640
    height: 480

    property bool txtSmooth: true
    property color backgroundColor: "ivory"
    property color currentItemColor: "#FFF8C6"
    property color pressColor: "#FDE688"
    property int listFontSize : 32

    property string activePos: "http://finance.google.com/finance/feeds/default/portfolios/1/positions"
    property int selectedIdx: 0
    property bool editMode: false
    property bool pfoLocal: false
    property int gPfoLength: 0

    signal close
    signal update

    PosEdit {
        id: posEditView
        anchors.fill: parent
        visible: false
        // Assigning pfoLocal not working
        editMode: true //pfoLocal
        pfoLocal: true //pfoLocal

        onClose: { container.state = "edit"; }
    }

    ListView {
        id: pfoView
        anchors.fill: parent
        model: pfoModel
        delegate: pfoDelegate
        snapMode: ListView.SnapToItem
    }

    Component {
        id: pfoDelegate

        Item {
            id: pfoDelegateItem
            width: pfoView.width
            height: 70

            Rectangle {
                id: background
                x: 5; y: 2; width: parent.width - x*2; height: parent.height - y*2
                color: container.backgroundColor
                border.color: "#3577B9"
                radius: 5
            }

            Text {
                id: nameBox
                anchors { top: background.top; left: background.left; leftMargin: 20; }//verticalCenter: parent.verticalCenter }

                smooth: txtSmooth
                font.bold: true
                font.pixelSize: listFontSize
                //verticalAlignment: Text.AlignVCenter
                text: name
            }

            Text {
                id: excerptBox
                anchors { top: nameBox.bottom; left: background.left; leftMargin: 40; }

                smooth: txtSmooth
                color: "#808080"
                font.pixelSize: listFontSize - 14
                //verticalAlignment: Text.AlignVCenter
                text: excerpt
            }

            Text {
                id: countBoxHidden
                visible: false
                text: num
            }

            MouseArea {
                id: mouseArea
                anchors.fill: background
                onClicked: {
                    selectedIdx = index;
                    pfoDelegateItem.ListView.view.currentIndex = index;

                    // Don't load for locally-created portfolio
                    if (!local) {
                        pfoLocal  = false;
                        activePos = feedLink;
                        console.log(activePos);

                        container.update();
                    }
                    else {
                        pfoLocal  = true;
                        activePos = index;

                        if (editMode) { container.state = "posEdit"; }
                        else          { container.state = "";        }
                    }
                }

                // Edit current local portfolio
                onPressAndHold: {
                    if (local&&editMode) {
                        reloadEditDialog(name, excerpt, num);
                        container.state = "entry";
                    }
                }
            }

            // Overload as delete button, only available for local portfolio
            SimpleButton {
                id: countBox
                anchors { right: background.right; rightMargin: 10; }
                anchors.verticalCenter: background.verticalCenter
                width: countBoxHidden.width+20
                color: (local) ? ((editMode) ? "#FF5555" : "#FFE9CA") : "#E0ECF7"
                pressedColor: (local&&editMode) ? "#FC3A3A" : "#E0ECF7"
                text: (local&editMode) ? "X" : num
                textColor: (local&editMode) ? "white" : "grey"
                textSize: listFontSize
                radius: 10

                onClicked: {
                    if (local&editMode) {
                        // Get local portfolio index
                        //fileHandler.removePfo(index - gPfoLength);
                        pfoModel.remove(index);
                    }
                }
           }

            states: [
                State {
                    name: "Pressed"
                    when: mouseArea.pressed
                    PropertyChanges { target: background; color: container.pressColor }
                },
                State {
                    name: "highlightCurrentItem"
                    when: selectedIdx == index
                    PropertyChanges { target: background; color: container.currentItemColor }
                }
            ]
        }
    }

    BackButton {
        id: backButton
        anchors { bottom: container.bottom; left: container.left; leftMargin: 20; bottomMargin: 20; }
        width: 65
        height: 65
        onClicked: {
            if (container.state=="")          { container.close();    }
            else if (container.state=="edit") { container.state = ""; }
        }
    }

    TextButton {
        id: addButton
        anchors { bottom: parent.bottom; right: editButton.left; rightMargin: 20; bottomMargin: 20; }
        width: 60
        height: addButton.width
        radius: addButton.width
        visible: false

//        color: "#F2F2F2"
//        lightColor: "#FFFFFF"
        color: "#B0D8FF"
        lightColor: addButton.color
        pressColor: addButton.color

        text: "+"
        textColor: "#B0D8FF"
        textSize: 60
        textBold: true

        onClicked: {
            resetEditDialog();

            container.state = "entry";
        }
    }

    // Overload to do delete/save
    TextButton {
        id: editButton
        anchors { bottom: parent.bottom; right: parent.right; rightMargin: 20; bottomMargin: 20; }
        width: 60
        height: editButton.width
        radius: editButton.width

//        color: "#F2F2F2"
//        lightColor: "#FFFFFF"
        color: "#B0D8FF"
        lightColor: editButton.color
        pressColor: editButton.color

        text: "+"
        textColor: "#B0D8FF"
        textSize: 50
        textBold: true

        onClicked: {
            if (container.state=="") { container.state = "edit"; }
            else {
                // Save
                //fileHandler.storePfo();

                container.state = "";
            }
        }
    }

    Edit {
        id: editDialog
        state: "hidden"
        pfoMode: true

        onSave: {
            if (editDialog.myPfoName!="") {
                //fileHandler.appendPfo(editDialog.myPfoName, editDialog.myPfoDesc, 5);
                //fileHandler.storePfo();

                pfoModel.append({
                                "local": 1,
                                "name": editDialog.myPfoName,
                                "feedLink": "",
                                "excerpt": editDialog.myPfoDesc,
                                "num": 0
                });
            }

            container.state = "";
        }

        onCancel: { container.state = "edit"; }
    }

    states: [
        State {
            name: "entry"
            PropertyChanges { target: editDialog; state: "shown"  }
            StateChangeScript {
                name: "debug"
                script: { console.log("pfoMenu.entry") }
            }
        },
        State {
            name: "edit"
            PropertyChanges { target: addButton; visible: true  }
            PropertyChanges { target: editButton; text: "S"  }

            PropertyChanges { target: container; editMode: true  }
            StateChangeScript {
                name: "debug"
                script: { console.log("pfoMenu.edit") }
            }
        },
        State {
            name: "posEdit"
            PropertyChanges { target: posEditView; visible: true  }
            PropertyChanges { target: pfoView; visible: false  }

            PropertyChanges { target: backButton; visible: false  }
            PropertyChanges { target: addButton; visible: false  }
            PropertyChanges { target: editButton; visible: false  }

            StateChangeScript {
                name: "debug"
                script: { console.log("pfoMenu.posEdit") }
            }
        }
    ]

    function resetEditDialog() {
        editDialog.myPfoName   = "";
        editDialog.myPfoDesc   = "";
    }

    function reloadEditDialog(name, excerpt) {
        editDialog.myPfoName   = name;
        editDialog.myPfoDesc  = excerpt;
    }
}


