#include <QDeclarativeContext>
#include <QtGui/QApplication>
#include "qmlapplicationviewer.h"
#include "windowhelper.h"
#include "filehandler.h"

#ifdef HAVE_GLWIDGET

#include <QGLWidget>

#endif

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    QmlApplicationViewer viewer;

#ifdef HAVE_GLWIDGET
    QGLWidget *glWidget = new QGLWidget(&viewer);
    viewer.setViewport(glWidget);
#endif

    WindowHelper *windowHelper = new WindowHelper();
    viewer.rootContext()->setContextProperty("windowHelper", windowHelper);
    FileHandler *fileHandler = new FileHandler();
    viewer.rootContext()->setContextProperty("fileHandler", fileHandler);

    viewer.setAttribute(Qt::WA_NoSystemBackground);
    //viewer.setAttribute(Qt::WA_OpaquePaintEvent);
    //viewer.viewport()->setAttribute(Qt::WA_OpaquePaintEvent);
    //viewer.viewport()->setAttribute(Qt::WA_NoSystemBackground);

    viewer.setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
    viewer.setMainQmlFile(QLatin1String("qml/stockona/main.qml"));

#ifdef Q_OS_SYMBIAN
    viewer.showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    viewer.showFullScreen();
#elif defined(Q_WS_SIMULATOR)
    //viewer.showExpanded();
    viewer.showFullScreen();
#else
    // we don't want full screen on meego tablets at least
    viewer.showMaximized();
#endif


    return app.exec();
}
