import QtQuick 1.0

Rectangle {
    id: container
    x: 2
    width: parent.width - 2*x
    height: 300
    focus: true
    radius: 5

    property int listFontSize: 28
    property int fontSize1: listFontSize - 2
    property color textInputBg: "#E2EFFC" //"#C2DEFA"
    property color breakBg: "#D5D5D5"

    property bool isYahooQuote: false
    property int refHeight: parent.height

    signal save
    signal cancel

    Grid {
        x: 20; y: 20;
        spacing: 20
        columns: 2
        width: parent.width

        Text {
            id: symbol
            text: "Symbol"
            font.pixelSize: fontSize1
        }

        Rectangle {
            id: symbolInRect
            width: parent.width/2
            height: fontSize1 + 4

            color: textInputBg
            radius: 5
            border.width: 1
            border.color: "#aaa"

            TextInput {
                id: symbolIn
                width: parent.width
                height: parent.height
                maximumLength: 30
                font.pixelSize: fontSize1
            }
        }

        Text {
            id: share
            text: "Share"
            font.pixelSize: fontSize1
        }

        Rectangle {
            width: parent.width/2
            height: fontSize1 + 4

            color: textInputBg
            radius: 5
            border.width: 1
            border.color: "#aaa"

            TextInput {
                id: shareIn
                width: parent.width
                height: parent.height
                maximumLength: 30
                font.pixelSize: fontSize1
            }
        }

        Text {
            id: cost
            text: "Cost"
            font.pixelSize: fontSize1
        }

        Rectangle {
            width: parent.width/2
            height: fontSize1 + 4

            color: textInputBg
            radius: 5
            border.width: 1
            border.color: "#aaa"

            TextInput {
                id: costIn
                width: parent.width
                height: parent.height
                maximumLength: 30
                font.pixelSize: fontSize1
            }
        }

        Text {
            id: pfoView
            font.pixelSize: listFontSize
            text: "Yahoo quote"
        }
        Rectangle {
            id: yahooBG
            x: 2
            width: fontSize1 + 4
            height: fontSize1 + 4

            color: textInputBg
            radius: 5
            border.width: 1
            border.color: "#aaa"
            smooth: true

            Rectangle {
                id: yahooSelBG
                x: 4; y: 4;
                width: parent.height - 2*x
                height: parent.height - 2*y
                radius: 5
                smooth: true
                visible: container.isYahooQuote
                color: "#7DBFFF"
            }

            MouseArea {
                id: yahooMouseArea
                anchors.fill: parent
                onClicked: { container.isYahooQuote = !container.isYahooQuote; }
            }
        }

        TextButton {
            id: saveButton
            text: "Save"
            onClicked: {
                fileHandler.storePfo(symbolIn.text, container.isYahooQuote);
                pfoModel.append({
                    "local": 1,
                    "name": symbolIn.text,
                    "feedLink": "",
                    "excerpt": "Locally stored portfolio",
                    "num": 0
                });
                container.save();
            }
        }

        TextButton {
            id: cancelButton
            text: "Cancel"
            onClicked: {
                fileHandler.loadPfo();
                console.log(refHeight);
                container.cancel();
            }
        }
    }

    states: [
        State {
            name: "hidden"
            PropertyChanges { target: container; y: refHeight }
        },
        State {
            name: "shown"
            PropertyChanges { target: container; y: refHeight - container.height }
        }
    ]

    transitions: Transition {
        SequentialAnimation {
            PropertyAnimation {
                target: container
                properties: "y"
                duration: 300
                easing.type: "OutQuad"
            }
        }
    }
}

