import QtQuick 1.0

Item {
    id: container
    width: 640
    height: 480
    //color: "#B0D8FF"

    property bool usePortfolioView: false
    property bool useWidgetView: false

    property color statColor: "#595454"
    property int statTopMargin: 0
    property int listFontSize : 48
    property int fontSize1: listFontSize - 7
    property int fontSize2: listFontSize - 25
    property int fontSize3: listFontSize - 23

    property int selectedIdx: 0
    property string chartView: ""
    property string chartCmp: ""
    //property alias contentHeight: posView.contentHeight

    property bool isLandscape: ( width > height )

    signal inNewsView
    signal inStatsView
    signal close

    //* Internal data. The ListModel get method can be invalid so binding is not good.
    property string myName            : ""
    property string myExg             : ""
    property string myFullname        : ""

    property string myQuotePrice      : ""
    property color  myQuoteChgColor   : "green"
    property string myQuoteChg        : ""
    property string myQuoteChgPtg     : ""
    property string myQuoteAsk        : ""
    property string myQuoteBid        : ""
    property string myShare           : ""
    property string myShareValue      : ""
    property string myShareCost       : ""
    property string myShareDayGain    : ""
    property string myShareGain       : ""
    property string myShareGainPercent: ""

    property string myQuoteDayHi      : ""
    property string myQuoteDayLo      : ""
    property string myQuote52wHi      : ""
    property string myQuote52wLo      : ""
    property string myQuoteMktCap     : ""

    property string myQuoteEps        : ""
    property string myQuotePe         : ""
    property string myQuoteBeta       : ""
    property string myQuoteVol        : ""
    property string myQuoteAvgVol     : ""

    function changeState() {
        container.state = 'details';
        container.inStatsView();
    }

    // Portrait detail windows

    Loader {
        id: viewLoader
        width: parent.width
        anchors.fill: parent
        sourceComponent: useWidgetView ? widgetViewComp : posViewComp
        onLoaded: viewLoaderAnim.start()
    }

    Item {
        id: portraitDetail
        anchors.fill: parent
        opacity: 0

        Text {
            id: symbolBox
            anchors { left: parent.left; leftMargin: 10 }

            font.bold: true
            font.pixelSize: listFontSize
            text: myName
        }

        Text {
            id: priceBox
            anchors { top: parent.top; left: symbolBox.right; leftMargin: 20; rightMargin: 5; topMargin: 5 }

            font.pixelSize: fontSize1
            text: myQuotePrice
        }

        Text {
            id: gainBox
            anchors { top: priceBox.bottom; left: parent.left; leftMargin: 10; rightMargin: 5; topMargin: 5 }

            color: myQuoteChgColor //posView.model.get(posView.currentIndex).quoteChgColor
            font.pixelSize: fontSize1
            text: myQuoteChg + " (" + myQuoteChgPtg + "%)"
        }

        Text {
            id: askBidBox
            anchors { top: gainBox.bottom; left: parent.left; leftMargin: 10; rightMargin: 5; topMargin: 10 }

            color: statColor
            font.pixelSize: fontSize3 + 2
            text: "Ask: " + myQuoteAsk + " / Bid: " + myQuoteBid
        }

        Text {
            id: infoBox
            anchors { top: parent.top; right: parent.right; rightMargin: 10; topMargin: statTopMargin}

            color: statColor
            font.pixelSize: fontSize3
            horizontalAlignment: Text.AlignRight
//            text: ("Share: " + myShare + "\nValue: " + myShareValue + "\nCost: " + myShareCost + "\nDayG: " + myShareDayGain + "\nGain: " + myShareGain + "\nReturn: " + myShareGainPercent + "%")
            text: ("Share: " + myShare + "<br>Value: " + myShareValue + "<br>Cost: " + myShareCost + "<br>DayG: " + myShareDayGain + "<br>Gain: " + myShareGain + "<br>Return: " + myShareGainPercent + "%")
        }



        Flickable {
            id: detailFlick
            //anchors.fill: parent
            anchors { top: infoBox.bottom; left: parent.left; right: parent.right; bottom: parent.bottom }
            anchors { bottomMargin: 10; leftMargin: 10; rightMargin: 10 }
            anchors.topMargin: 10
            contentWidth:  (chartView == "") ? parent.width : 512
            contentHeight: (chartView == "") ? 500 : 750 // chart.width
            clip: true

            // Line separator
            Rectangle {
                id: separator1
                anchors { top: parent.top; }
                width: parent.width
                height: 2
                color: "#D5D5D5"
            }

            Text {
                id: detailSymText;
                anchors { left: separator1.left; top: separator1.bottom; topMargin: 10 }
                color: statColor
                font.pixelSize: fontSize3
                elide: Text.ElideRight
                text: myExg + " - " + myFullname
            }

            SimpleButton {
                id: newsButton
                anchors { left: detailSymText.left; top: detailSymText.bottom; topMargin: 10 }
                text: "Related News"
                textSize: fontSize3

                onClicked: {
                    rssModel.source = "http://www.google.com/finance/company_news?q=" + myExg + ":" + myName + "&output=rss";
                    container.inNewsView();
                }
            }

            Text {
                id: detailRangeText;
                anchors { top: newsButton.bottom; left: parent.left; topMargin: 10;  }
                color: statColor
                wrapMode: Text.WordWrap;
                font.pixelSize: fontSize3
                text: "Day High: " + myQuoteDayHi + "\nDay Low: " + myQuoteDayLo + "\n52w High: " + myQuote52wHi + "\n52w Low: " + myQuote52wLo + "\nMkt Cap: " + myQuoteMktCap;
            }

            Text {
                id: detailStatsText;
                anchors { top: newsButton.bottom; right: parent.right; topMargin: 10; }
                color: statColor
                wrapMode: Text.WordWrap;
                font.pixelSize: fontSize3
                text: "EPS: " + myQuoteEps + "\nPE: " + myQuotePe + "\nBeta: " + myQuoteBeta + "\nVol: " + myQuoteVol + "\nAvg Vol: " + myQuoteAvgVol;
            }

            // Line separator
            Rectangle {
                id: separator3
                anchors { top: detailStatsText.bottom; topMargin: 10 }
                width: parent.width
                height: 2
                color: "#D5D5D5"
            }

            SimpleButton{
                id: chartSel1
                width: (parent.width - 20)/6
                anchors { top: separator3.bottom; topMargin: 10 }
                text: "5d"
                textSize: fontSize2

                onClicked: { container.chartView = "5d"; }
            }
            SimpleButton{
                id: chartSel2
                width: (parent.width - 20)/6
                anchors { top: separator3.bottom; left: chartSel1.right; topMargin: 10; leftMargin: 5 }
                text: "3m"
                textSize: fontSize2

                onClicked: { container.chartView = "3m"; }
            }
            SimpleButton{
                id: chartSel3
                width: (parent.width - 20)/6
                anchors { top: separator3.bottom; left: chartSel2.right; topMargin: 10; leftMargin: 5 }
                text: "6m"
                textSize: fontSize2

                onClicked: { container.chartView = "6m"; }
            }
            SimpleButton{
                id: chartSel4
                width: (parent.width - 20)/6
                anchors { top: separator3.bottom; left: chartSel3.right; topMargin: 10; leftMargin: 5 }
                text: "1y"
                textSize: fontSize2

                onClicked: { container.chartView = "1y"; }
            }
            SimpleButton{
                id: chartSel5
                width: (parent.width - 20)/6
                anchors { top: separator3.bottom; left: chartSel4.right; topMargin: 10; leftMargin: 5 }
                text: "2y"
                textSize: fontSize2

                onClicked: { container.chartView = "2y"; }
            }
            SimpleButton{
                id: chartSel6
                width: (parent.width - 20)/6
                anchors { top: separator3.bottom; left: chartSel5.right; right: separator3.right; topMargin: 10; leftMargin: 5 }
                text: "5y"
                textSize: fontSize2

                onClicked: { container.chartView = "5y"; }
            }
            ProgressBar {
                id: chartProgress
                width: parent.width
                height: 10
                anchors { top: chartSel1.bottom; topMargin: 5; }
                anchors.horizontalCenter: parent.horizontalCenter
                barColor: "#2954FF"
                bgColor: "#2954FF"

                progress: chart.progress

                states: State {
                    name: "hideProgress"
                    when: (chart.status!=Image.Loading)
                    PropertyChanges { target: chartProgress; opacity: 0 }
                }
            }

            Item {
                id: chartItem
                anchors { top: chartSel1.bottom; topMargin: 20; }
                anchors.horizontalCenter: parent.horizontalCenter

                Image {
                    id: chart
                    anchors.horizontalCenter: parent.horizontalCenter

                    width: 512
                    height: 288
                    //source: (chartView=="") ? "" : "http://chart.finance.yahoo.com/c/" + chartView + "/s/" + convertExchangeForYahoo(myName, myExg);
                    source: (chartView=="") ? "" : "http://chart.finance.yahoo.com/z?s=" + convertExchangeForYahoo(myName, myExg) + "&t=" + chartView + "&q=l&l=off&z=m&a=v" + chartCmp;
                    MouseArea {
                        anchors.fill: parent
                        onClicked: {
                            if (chartCmp=="") { chartCmp = "&c=^GSPC"; }
                            else              { chartCmp = "";         }
                        }
                    }
                }
            }
        }
    }

    // Landscape detail windows
    Item {
        id: landscapeDetail
        anchors.fill: parent
        opacity: 0

        Text {
            id: symbolBoxLs
            anchors { left: parent.left; leftMargin: 10; topMargin: 10 }

            font.bold: true
            font.pixelSize: listFontSize
            text: myName
        }

        Text {
            id: priceBoxLs
            anchors { top: parent.top; left: symbolBoxLs.right; leftMargin: 10; rightMargin: 10; topMargin: 5 }

            font.pixelSize: fontSize1
            text: myQuotePrice
        }

        Text {
            id: gainBoxLs
            anchors { top: priceBoxLs.bottom; left: parent.left; leftMargin: 10; rightMargin: 10; topMargin: 5 }

            color: myQuoteChgColor
            font.pixelSize: fontSize1
            text: myQuoteChg + " (" + myQuoteChgPtg + "%)"
        }

        Text {
            id: askBidBoxLs
            anchors { top: gainBoxLs.bottom; left: parent.left; leftMargin: 20; rightMargin: 10; topMargin: 5 }

            color: statColor
            font.pixelSize: fontSize3 + 2
            text: "Ask: " + myQuoteAsk + "\nBid: " + myQuoteBid
        }

        Rectangle {
            id: separator0Ls
            anchors { top: askBidBoxLs.bottom; left: parent.left; topMargin: 5; bottomMargin: 5; leftMargin: 10 }
            width: (gainBoxLs.width > (symbolBoxLs.width+priceBoxLs.width)) ? gainBoxLs.width : (symbolBoxLs.width + priceBoxLs.width)
            height: 2
            color: "#D5D5D5"
        }

        Text {
            id: infoBoxLs
            anchors { top: separator0Ls.bottom; left: parent.left; leftMargin: 20; rightMargin: 10; topMargin: 5}

            color: statColor
            font.pixelSize: fontSize3
            //horizontalAlignment: Text.AlignRight
            text: ("Share: " + myShare + "\nValue: " + myShareValue + "\nCost: " + myShareCost + "\nDayG: " + myShareDayGain + "\nGain: " + myShareGain + "\nReturn: " + myShareGainPercent + "%")
        }

        Flickable {
            id: detailFlickLs
            anchors { top: parent.top; left: separator0Ls.right; right: parent.right; bottom: parent.bottom }
            anchors { bottomMargin: 10; leftMargin: 10; rightMargin: 10; }
            contentWidth: (chartView == "") ? detailFlickLs.width : ( (detailFlickLs.width>512) ? detailFlickLs.width : 512 )
            contentHeight: (chartView == "") ? 500 : 700 // chart.width
            clip: true

            // Line separator
            Text {
                id: detailSymTextLs;
                anchors { left: parent.left; top: parent.top; }
                //wrapMode: Text.WordWrap;
                color: statColor
                font.pixelSize: fontSize3
                elide: Text.ElideRight
                text: myExg + " - " + myFullname
                //text: posView.model.get(posView.currentIndex).exchange + " - " + posView.model.get(posView.currentIndex).fullName;
            }

            SimpleButton {
                id: newsButtonLs
                anchors { left: detailSymTextLs.left; top: detailSymTextLs.bottom; topMargin: 10 }
                text: "Related News"
                textSize: fontSize3

                onClicked: {
                    rssModel.source = "http://www.google.com/finance/company_news?q=" + myExg + ":" + myName + "&output=rss";
                    container.inNewsView();
                }
            }

            Text {
                id: detailRangeTextLs;
                anchors { top: newsButtonLs.bottom; left: parent.left; topMargin: 10;  }
                color: statColor
                wrapMode: Text.WordWrap;
                font.pixelSize: fontSize3
                text: "Day High: " + myQuoteDayHi + "\nDay Low: " + myQuoteDayLo + "\n52w High: " + myQuote52wHi + "\n52w Low: " + myQuote52wLo + "\nMkt Cap: " + myQuoteMktCap;
                //text: "Day High: " + posView.model.get(posView.currentIndex).quoteDayHi + "\nDay Low: " + posView.model.get(posView.currentIndex).quoteDayLo + "\n52w High: " + posView.model.get(posView.currentIndex).quote52wHi + "\n52w Low: " + posView.model.get(posView.currentIndex).quote52wLo + "\nMkt Cap: " + posView.model.get(posView.currentIndex).quoteMktCap;

            }

            Text {
                id: detailStatsTextLs;
                anchors { top: newsButtonLs.bottom; right: parent.right; topMargin: 10; }
                color: statColor
                wrapMode: Text.WordWrap;
                font.pixelSize: fontSize3
                text: "EPS: " + myQuoteEps + "\nPE: " + myQuotePe + "\nBeta: " + myQuoteBeta + "\nVol: " + myQuoteVol + "\nAvg Vol: " + myQuoteAvgVol;
                //text: "EPS: " + posView.model.get(posView.currentIndex).quoteEps + "\nPE: " + posView.model.get(posView.currentIndex).quotePe + "\nBeta: " + posView.model.get(posView.currentIndex).quoteBeta + "\nVol: " + posView.model.get(posView.currentIndex).quoteVol + "\nAvg Vol: " + posView.model.get(posView.currentIndex).quoteAvgVol;

            }

            // Line separator
            Rectangle {
                id: separator3Ls
                anchors { top: detailStatsTextLs.bottom; topMargin: 10 }
                width: parent.width
                height: 2
                color: "#D5D5D5"
            }

            SimpleButton{
                id: chartSel1Ls
                width: (parent.width - 20)/6
                anchors { top: separator3Ls.bottom; topMargin: 10 }
                text: "5d"
                textSize: fontSize2

                onClicked: { container.chartView = "5d"; }
            }
            SimpleButton{
                id: chartSel2Ls
                width: (parent.width - 20)/6
                anchors { top: separator3Ls.bottom; left: chartSel1Ls.right; topMargin: 10; leftMargin: 5 }
                text: "3m"
                textSize: fontSize2

                onClicked: { container.chartView = "3m"; }
            }
            SimpleButton{
                id: chartSel3Ls
                width: (parent.width - 20)/6
                anchors { top: separator3Ls.bottom; left: chartSel2Ls.right; topMargin: 10; leftMargin: 5 }
                text: "6m"
                textSize: fontSize2

                onClicked: { container.chartView = "6m"; }
            }
            SimpleButton{
                id: chartSel4Ls
                width: (parent.width - 20)/6
                anchors { top: separator3Ls.bottom; left: chartSel3Ls.right; topMargin: 10; leftMargin: 5 }
                text: "1y"
                textSize: fontSize2

                onClicked: { container.chartView = "1y"; }
            }
            SimpleButton{
                id: chartSel5Ls
                width: (parent.width - 20)/6
                anchors { top: separator3Ls.bottom; left: chartSel4Ls.right; topMargin: 10; leftMargin: 5 }
                text: "2y"
                textSize: fontSize2

                onClicked: { container.chartView = "2y"; }
            }
            SimpleButton{
                id: chartSel6Ls
                width: (parent.width - 20)/6
                anchors { top: separator3Ls.bottom; left: chartSel5Ls.right; right: separator3Ls.right; topMargin: 10; leftMargin: 5 }
                text: "5y"
                textSize: fontSize2

                onClicked: { container.chartView = "5y"; }
            }
            ProgressBar {
                id: chartProgressLs
                width: parent.width
                height: 10
                anchors { top: chartSel1Ls.bottom; topMargin: 5; }
                anchors.horizontalCenter: parent.horizontalCenter
                barColor: "#2954FF"
                bgColor: "#2954FF"

                progress: chartLs.progress

                states: State {
                    name: "hideProgress"
                    when: (chartLs.status!=Image.Loading)
                    PropertyChanges { target: chartProgressLs; opacity: 0 }
                }
            }

            // Helper: http://developer.qt.nokia.com/forums/viewthread/5639
            Item {
                id: chartItemLs
                anchors { top: chartSel1Ls.bottom; topMargin: 20; }
                anchors.horizontalCenter: parent.horizontalCenter

                Image {
                    id: chartLs
                    anchors.horizontalCenter: parent.horizontalCenter

                    width: 512
                    height: 288
                    //source: (chartView=="") ? "" : "http://chart.finance.yahoo.com/c/" + chartView + "/s/" + convertExchangeForYahoo(myName, myExg);
                    source: (chartView=="") ? "" : "http://chart.finance.yahoo.com/z?s=" + convertExchangeForYahoo(myName, myExg) + "&t=" + chartView + "&q=l&l=off&z=m&a=v" + chartCmp;
                    MouseArea {
                        anchors.fill: parent
                        onClicked: {
                            if (chartCmp=="") { chartCmp = "&c=^GSPC"; }
                            else             { chartCmp = "";         }
                        }
                    }

                }
            }
//            MouseArea {
//                id: detailMouseArea
//                anchors.fill: portraitDetail
//                onClicked: {
//                    chartView = "";
//                    container.state='';
//                    container.close();
//                }
//            }
        }
    }

    Component {
       id: posViewComp
    ListView {
        id: posView
        anchors.fill: parent
        model: posModel
        delegate: posDelegate
        snapMode: ListView.SnapToItem
    }
    }

    // Qt Quick 1.0 doesn't store state, so use ugly conditional operator for now
    Component {
        id: posDelegate

        Item {
            id: posDelegateItem
            width: posView.width
            height: 150

            Rectangle {
                id: background
                x: 2; y: 2; width: parent.width - x*2; height: parent.height - y*2

                color: "ivory"
//                border.color: "#3577B9" //"orange"

                radius: 5
            }

            Text {
                id: symbolBox
                anchors { left: background.left; leftMargin: 10 }

                font.bold: true
                font.pixelSize: listFontSize
                text: name
            }

            Text {
                id: priceBox
                anchors { top: background.top; left: symbolBox.right; leftMargin: 20; rightMargin: 5; topMargin: 5 }

                font.pixelSize: fontSize1
                text: quotePrice
            }

            Text {
                id: gainBox
                anchors { top: priceBox.bottom; left: background.left; leftMargin: 10; rightMargin: 5; topMargin: 5 }
                color: quoteChgColor
                font.pixelSize: fontSize1
                text: quoteChg + " (" + quoteChgPtg + "%)"
            }

            Text {
                id: infoBox1
                anchors { top: background.top; right: background.right; rightMargin: 10; topMargin: statTopMargin }

                color: statColor
                font.pixelSize: fontSize2
                horizontalAlignment: Text.AlignRight

                text: usePortfolioView ? ("Share: " + share) : ("High: " + quoteDayHi)

                // Using <br> slows down rendering, so break up into 5 info boxes
//                text: usePortfolioView ? ("Share: " + share + "\nValue: " + shareValue + "\nCost: " + shareCost + "\nGain: " + shareGain + "\nReturn: " + shareGainPercent + "%") :
//                ("High: " + quoteDayHi + "\nLow: " + quoteDayLo + "\nAsk: " + quoteAsk + "\nBid: " + quoteBid + "\nVol: " + quoteVol)
            }

            Text {
                id: infoBox2
                anchors { top: infoBox1.bottom; right: background.right; rightMargin: 10; topMargin: statTopMargin }

                color: statColor
                font.pixelSize: fontSize2
                horizontalAlignment: Text.AlignRight

                text: usePortfolioView ? ("Value: " + shareValue) : ("Low: " + quoteDayLo)
            }

            Text {
                id: infoBox3
                anchors { top: infoBox2.bottom; right: background.right; rightMargin: 10; topMargin: statTopMargin }

                color: statColor
                font.pixelSize: fontSize2
                horizontalAlignment: Text.AlignRight

                text: usePortfolioView ? ("Cost: " + shareCost) : ("Ask: " + quoteAsk)
            }

            Text {
                id: infoBox4
                anchors { top: infoBox3.bottom; right: background.right; rightMargin: 10; topMargin: statTopMargin }

                color: statColor
                font.pixelSize: fontSize2
                horizontalAlignment: Text.AlignRight

                text: usePortfolioView ? ("Gain: " + shareGain) : ("Bid: " + quoteBid)
            }

            Text {
                id: infoBox5
                anchors { top: infoBox4.bottom; right: background.right; rightMargin: 10; topMargin: statTopMargin }

                color: statColor
                font.pixelSize: fontSize2
                horizontalAlignment: Text.AlignRight

                text: usePortfolioView ? ("Return: " + shareGainPercent + "%") : ("Vol: " + quoteVol)
            }

            MouseArea {
                id: posMouseArea
                anchors.fill: background
                onClicked: {
                    selectedIdx = index;
                    posName = name;
                    posDelegateItem.ListView.view.currentIndex = index;
                    fetchPosData();
                    changeState();
                }
            }
        }
    }

    Component {
        id: widgetViewComp

    ListView {
        id: widgetView
        anchors.fill: parent
        model: posModel
        delegate: widgetDelegate
        snapMode: ListView.SnapToItem
        //opacity: 0
    }
    }

    Component {
        id: widgetDelegate

        Item {
            id: posDelegateItem
            width: widgetView.width
            height: 59

            Rectangle {
                id: background
                x: 2; y: 2; width: parent.width - x*2; height: parent.height - y*2

                color: "black"
            }

            Text {
                id: symbolBox
                anchors { top: background.top; bottom: background.bottom; left: background.left; leftMargin: 10; }
                color: "white"

                font.bold: true
                font.pixelSize: 35
                text: name
                verticalAlignment: Text.AlignVCenter
            }

            Text {
                id: priceBox
                anchors { top: background.top; bottom: background.bottom; left: symbolBox.right; leftMargin: 20; rightMargin: 5; }
                color: "#E8E8E8"

                font.pixelSize: symbolBox.font.pixelSize - 6
                text: quotePrice
                verticalAlignment: Text.AlignVCenter
            }

            Text {
                id: gainBox
                anchors { top: background.top; bottom: background.bottom; right: background.right; leftMargin: 10; rightMargin: 10; }
                color: quoteChgColor

                font.pixelSize: symbolBox.font.pixelSize - 6
                text: quoteChg + " (" + quoteChgPtg + "%)"
                verticalAlignment: Text.AlignVCenter
            }

            MouseArea {
                id: posMouseArea
                anchors.fill: background
                onClicked: {
                    selectedIdx = index;
                    posName = name;
                    posDelegateItem.ListView.view.currentIndex = index;
                    fetchPosData();
                    changeState();
                }
            }
        }
    }

    states: [
        State {
            name: ""
        },
        State {
            name: "details"

            PropertyChanges { target: portraitDetail; opacity: !isLandscape  }
            PropertyChanges { target: landscapeDetail; opacity: isLandscape  }
            PropertyChanges { target: viewLoader; opacity: 0; }
            PropertyChanges { target: backButton; opacity: 1  }


            // Change color to avoid flash in transition from default to details
            PropertyChanges { target: mainWindow; color: "ivory" }
       },
        State {
            name: "widgetView"
            when: useWidgetView

            // Keep mainWindow change local to posView
            PropertyChanges { target: mainWindow; color: "black" }
            PropertyChanges { target: header; color: "grey" }
        }
    ]

    transitions: [
        Transition {
            ParallelAnimation {
                PropertyAnimation { target: portraitDetail; properties: "opacity"; from:0; duration: 130}
                PropertyAnimation { target: landscapeDetail; properties: "opacity"; from: 0; duration: 130}
                PropertyAnimation { target: backButton; properties: "opacity"; duration: 130}
            }
        }
    ]

    PropertyAnimation { id:viewLoaderAnim; target: viewLoader; properties: "opacity"; from:0; to: 1; easing.type: Easing.InBack; duration: 130 }

    BackButton {
        id: backButton
        anchors { bottom: container.bottom; left: container.left; }
        anchors.leftMargin: isLandscape ? 10: 20;
        anchors.bottomMargin: isLandscape ? 10 : 20;
        opacity: 0

        width: isLandscape ? 55: 65
        height: isLandscape ? 55 : 65
        onClicked: {
            chartView = "";
            container.state = (useWidgetView) ? "widgetView" : "";
            container.close();
        }
    }
}


