import QtQuick 1.0

Item {
    id: container
    width: 640
    height: 480

    property color backgroundColor: "ivory"
    property color currentItemColor: "#FFF8C6"
    property color pressColor: "#FDE688"
    property int listFontSize : 32

    property string activePos: "http://finance.google.com/finance/feeds/default/portfolios/1/positions"
    property int pfoSelectedIdx: 0
    property bool editMode: false    

    property bool pfoIsLocal: false
    property bool pfoIsYahoo: false

    property int gPfoLength: 0

    signal close
    signal update

    /////////////////////////////
    // Function
    /////////////////////////////
    function resetEditDialog() {
        editDialog.myPfoName   = "";
        editDialog.myPfoDesc   = "";
    }

    function reloadEditDialog(name, excerpt, isYahoo) {
        editDialog.myPfoName  = name;
        editDialog.myPfoDesc  = excerpt;
        editDialog.myIsYahoo   = isYahoo;
    }

    function updatePfoNum(idx) {
        // C-model pfoNum is saved in storePos functions
        pfoModel.set(pfoSelectedIdx, {"num": fileHandler.localPosSymbol.length});
    }

    function loadLocalDataToPosModel(idx) {
        // Don't use clear, for some reasons the clear affects posEditView
        //posModel.clear();

        for (var i=posModel.count-1; i>=0; i--) {
            //console.log("Remove "+posModel.get(i).name);
            posModel.remove(i);
        }

        var fileOk = fileHandler.loadPos(idx);

        if (fileOk==0){
            for (var i=0; i < fileHandler.localPosSymbol.length; i++) {
                console.log("LoadPos: " + i + "," + fileHandler.localPosSymbol[i]);
                posModel.append({
                    "name": fileHandler.localPosSymbol[i],
                    "exchange": fileHandler.localPosExg[i],
                    "share": fileHandler.localPosShare[i],
                    "shareCost": fileHandler.localPosCost[i]
                    //"stopPrice": fileHandler.localPosStop[i]
                });
            }
        }
        else {
            console.log("Cannot load local position");
        }
    }

    function storePfo() {
        fileHandler.removePfoAll();

        var cnt = 0;
        var posFileIdx = 0;

        for (var i=0; i<pfoModel.count; i++) {
            if (pfoModel.get(i).local==1){
                console.log("storePfo: i=" + i + ", gPfoLength=" + cnt + ", name=" + pfoModel.get(i).name);
                console.log("storePfo: i=" + i + ", isYahoo=" + pfoModel.get(i).isYahoo);
                posFileIdx = i - cnt;
                var bool = (pfoModel.get(i).isYahoo==0) ? false : true;

                fileHandler.setPfo(posFileIdx, pfoModel.get(i).name, pfoModel.get(i).excerpt, bool);
            }
            else {
                cnt++;
            }
        }

        fileHandler.storePfoAll();
    }

    function calcGPfoLength() {
        var cnt = 0;

        for (var i=0; i<pfoModel.count; i++) {
            if (pfoModel.get(i).local==0) { cnt++; }
        }

        return cnt;
    }

    // Brute-force updating the position file indexes
    function updatePos(idx) {
        // idx is the pfo index to be removed.
        // Don't change for pfo index smaller than idx.
        for (var i=idx+1; i<(pfoModel.count - gPfoLength); i++) {
            console.log("updatePos: i=" + i)
            fileHandler.loadPos(i);
            fileHandler.storePosAll(i-1);
        }
    }

    function reseteditDialog() {
        editDialog.myPfoName   = "";
        editDialog.myPfoDesc   = "";

        editDialog.myName   = "";
        editDialog.myExg    = "";
        editDialog.myShare  = 0;
        editDialog.myCost   = 0;
        editDialog.myStop   = 0;
    }

    function addPfo(idx, update) {
        if (update) {
            pfoModel.set(pfoSelectedIdx, {
                         "local": 1,
                         "name": checkForDelimiter(editDialog.myPfoName),
                         "feedLink": "",
                         "excerpt": checkForDelimiter(editDialog.myPfoDesc),
                         "isYahoo": editDialog.myIsYahoo
            });
//            fileHandler.setPfo(idx, editDialog.myPfoName, editDialog.myPfoDesc, editDialog.myIsYahoo);
        }
        else {
            pfoModel.append({
                         "local": 1,
                         "name": checkForDelimiter(editDialog.myPfoName),
                         "feedLink": "",
                         "excerpt": checkForDelimiter(editDialog.myPfoDesc),
                         "isYahoo": editDialog.myIsYahoo,
                         "num": 0
            });
//        fileHandler.storePfoAll();
        }
    }

    /////////////////////////////
    // Main
    /////////////////////////////

    PosEdit {
        id: posEditView
        anchors.fill: parent
        visible: false

        // Assigning pfoLocal not working
        editMode: true //pfoLocal
        pfoIsLocal: true //pfoLocal

        onClose: {
            //updatePfoNum(posEditView.pfoLocalIdx);
            container.state = "edit";
        }
    }

    ListView {
        id: pfoView
        anchors.fill: parent
        anchors.bottomMargin: 90
        model: pfoModel
        delegate: pfoDelegate
        snapMode: ListView.SnapToItem
    }

    Component {
        id: pfoDelegate

        Item {
            id: pfoDelegateItem
            width: pfoView.width
            height: 70

            Rectangle {
                id: background
                x: 5; y: 2; width: parent.width - x*2; height: parent.height - y*2
                color: container.backgroundColor
                //border.color: "#3577B9"
                radius: 5
            }

            Text {
                id: nameBox
                anchors { top: background.top; left: background.left; leftMargin: 20; }//verticalCenter: parent.verticalCenter }

                font.bold: true
                font.pixelSize: listFontSize
                //verticalAlignment: Text.AlignVCenter
                text: name
            }

            Text {
                id: excerptBox
                anchors { top: nameBox.bottom; left: background.left; leftMargin: 40; }

                color: "#808080"
                font.pixelSize: listFontSize - 14
                //verticalAlignment: Text.AlignVCenter
                text: excerpt
            }

            Text {
                id: countBoxHidden
                visible: false
                text: num
            }

            MouseArea {
                id: mouseArea
                anchors.fill: background
                onClicked: {
                    gPfoLength = calcGPfoLength();

                    // pfoSelectedIdx: index in PfoList.
                    // activePos: index for local portfolio, start from zero.
                    pfoSelectedIdx = index;
                    pfoDelegateItem.ListView.view.currentIndex = index;
                    activePos = index - gPfoLength;
                    pfoName = pfoModel.get(index).name;

                    console.log("idx=" + index + " gPfoLength=" + gPfoLength + " activePos=" +activePos + " isY=" + isYahoo);

                    // Don't load for locally-created portfolio
                    if (!local) {
                        pfoIsLocal  = false;
                        pfoIsYahoo  = false;
                        activePos = feedLink;
                        console.log(activePos);

                        container.update();
                    }
                    else {
                        pfoIsLocal = true;

                        // Delete
                        if (mouse.x > (parent.width - 40)) {
                            if (local&editMode) {
                                //deleteDialog.open();
                                updatePos(pfoSelectedIdx-gPfoLength);
                                pfoModel.remove(pfoSelectedIdx);
                                storePfo();

                                // Jump to last portfolio
                                activePos = (activePos>0) ? activePos-1 : 0;
                                pfoSelectedIdx = (pfoSelectedIdx>0) ? pfoSelectedIdx-1 : 0;
                            }
                        }
                        // Go to posEditView or launch pfo
                        else {
                            posEditView.pfoLocalIdx = activePos;
                            posEditView.pfoIsYahoo  = pfoIsYahoo = isYahoo;

                            if (editMode) {
                                // Load data into posModel
                                loadLocalDataToPosModel(activePos);
                                container.state = "posEdit";
                            }
                            else {
                                console.log("Local pfo: " + posEditView.pfoLocalIdx);
                                container.update();
                                container.state = "";
                            }
                        }
                    }
                }

                // Edit current local portfolio
                // Long preess and hold doesn't fetch
                onPressAndHold: {
                    gPfoLength = calcGPfoLength();

                    pfoSelectedIdx = index;
                    pfoDelegateItem.ListView.view.currentIndex = index
                    activePos = index - gPfoLength;

                    if (local&&editMode) {
                        reloadEditDialog(name, excerpt, isYahoo);
                        container.state = "entryUpdate";
                    }
                }
            }

            SimpleRect {
                id: countBox
                anchors { right: background.right; rightMargin: 10; }
                anchors.verticalCenter: background.verticalCenter
                width: countBoxHidden.width+20
                color: (local) ? ((editMode) ? "#FF5555" : "#FFE9CA") : "#E0ECF7"
                text:  (local&editMode) ? "X" : num
                textColor: (local&editMode) ? "white" : "grey"
                textSize: listFontSize
                radius: 10
           }

            states: [
                State {
                    name: "Pressed"
                    when: mouseArea.pressed
                    PropertyChanges { target: background; color: container.pressColor }
                },
                State {
                    name: "highlightCurrentItem"
                    when: pfoSelectedIdx == index
                    PropertyChanges { target: background; color: container.currentItemColor }
                }
            ]
        }
    }

    Fader {
        fadingOpacity: 0.6
        // Bind our visibility status with Fader show/hide states.
        state: (container.state=="entry"||container.state=="entryUpdate") ? "faded" : ""
        transitionDuration: 200
        // Use the whole available area for fading & capturing key clicks.
        anchors.fill: parent
        // Use "light" fading color.
        color: "#f5f5f5"
    }

    BackButton {
        id: backButton
        anchors { bottom: container.bottom; left: container.left; leftMargin: 20; bottomMargin: 10; }
        width: 65
        height: 65
        onClicked: {
            if (container.state=="") {
                if (pfoIsLocal) { container.update(); }
                else           { container.close(); }
            }
            else if (container.state=="edit") { container.state = ""; }
        }
    }

    TextButton {
        id: storeButton
        anchors { bottom: parent.bottom; right: editButton.left; rightMargin: 20; bottomMargin: 10; }
        width: 60
        height: storeButton.width
        radius: storeButton.width
        visible: false

        color: "#F2F2F2"
        lightColor: "#FFFFFF"
        pressColor: storeButton.color

        text: "v"
        textColor: "#B0D8FF"
        textSize: 60

        onClicked: {
            // Save pfo
            storePfo();
            container.state = "";
        }
    }

    // Overload to do delete/save
    TextButton {
        id: editButton
        anchors { bottom: parent.bottom; right: parent.right; rightMargin: 20; bottomMargin: 10; }
        width: 60
        height: editButton.width
        radius: editButton.width

        color: "#F2F2F2"
        lightColor: "#FFFFFF"
        pressColor: editButton.color

        text: (container.state=="edit")? "+" : "="
        textColor: "#B0D8FF"
        textSize: 50
        textBold: true

        onClicked: {
            if (container.state=="") { container.state = "edit"; }
            else {
                // Add new entry
                resetEditDialog();
                container.state = "entry";
            }
        }
    }

    Edit {
        id: editDialog
        state: "hidden"
        pfoMode: true

        onSave: {
            if (editDialog.myPfoName!="") {
                // console.log(editDialog.myPfoName);
                if (container.state=="entryUpdate") { addPfo(activePos, 1); }
                else                              { addPfo(activePos, 0); }
            }

            container.state = "edit";
        }

        onCancel: { container.state = "edit"; }
    }

    states: [
        State {
            name: "entry"
            PropertyChanges { target: editDialog; state: "shown"  }
            StateChangeScript {
                script: { console.log("pfoMenu.entry") }
            }
        },
        State {
            name: "entryUpdate"
            PropertyChanges { target: editDialog; state: "shown"  }
            StateChangeScript {
                script: { console.log("pfoMenu.entryUpdate") }
            }
        },
        State {
            name: "edit"
            PropertyChanges { target: storeButton; visible: true  }

            PropertyChanges { target: container; editMode: true  }

            StateChangeScript {
                name: "debug"
                script: { console.log("pfoMenu.edit") }
            }
        },
        State {
            name: "posEdit"
            PropertyChanges { target: posEditView; visible: true  }
            PropertyChanges { target: pfoView; visible: false  }

            PropertyChanges { target: backButton; visible: false  }
            PropertyChanges { target: storeButton; visible: false  }
            PropertyChanges { target: editButton; visible: false  }

            StateChangeScript {
                name: "debug"
                script: { console.log("pfoMenu.posEdit") }
            }
        }
    ]
}


