#ifndef PFOMODEL_H
#define PFOMODEL_H

#include "listmodel.h"
#include <QObject>

class PfoItem : public ListItem
{
  Q_OBJECT

public:
    enum Roles {
      LocalRole = Qt::UserRole+1,
      IsYahooRole,
      NumRole,
      NameRole,
      FeedLinkRole,
      ExcerptRole
    };

  PfoItem(QObject *parent = 0): ListItem(parent) {}
  explicit PfoItem(const bool local, const bool isYahoo, const int num, const QString &name, const QString &feedLink, const QString &excerpt, QObject *parent = 0);
  QVariant data(int role) const;
  QHash<int, QByteArray> roleNames() const;

  inline bool local() const       { return m_local; }
  inline bool isYahoo() const     { return m_isYahoo; }
  inline int num() const          { return m_num; }
  inline QString name() const     { return m_name; }
  inline QString feedLink() const { return m_feedLink; }
  inline QString excerpt() const  { return m_excerpt; }

  /*
  "local": 0,
  "name": pfoName,
  "feedLink": pfoFeedLink,
  "isYahoo": false,
  "excerpt": "-",
  "num": 0
  */

private:
  bool m_local;
  bool m_isYahoo;
  int m_num;
  QString m_name;
  QString m_feedLink;
  QString m_excerpt;
};

#endif // PFOMODEL_H
