/*
    Stockona is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Stockona is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with NewsFlow. If not, see <http://www.gnu.org/licenses/>.
*/

//////////////////////////////////////
// WorkerScript
//////////////////////////////////////

var itemsURL = "";
var sid = "";
var model;

// 0: US; 1: Asia
var quoteChgColorMode = false;

WorkerScript.onMessage = function(msg) {
    sid = msg.sid;
    model = msg.model;
    quoteChgColorMode = msg.gainColorMode;

    if (msg.action == 'loadPosition') {
        console.log("worker.loadPosition");

//        loadOnePosition(msg.activePos, 0, msg.pfoIsYahoo, 0);
        loadOnePosition(msg.activePos, false, false, false);

        msg.model.sync();
    }
    // Network request blocks UI....
//    else if (msg.action == 'parseGooglePosition') {
//        console.log("worker.parseGooglePosition");

//        parseJSONAll(msg.data);

//        msg.model.sync();
//    }
}

//////////////////////////////////////
// Web
//////////////////////////////////////

function doWebRequest(method, url, params, callback, show) {
    var doc = new XMLHttpRequest();
    //console.log(method + " " + url);

    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.HEADERS_RECEIVED) {
            var status = doc.status;
            var statusText = doc.statusText;
        } else if (doc.readyState == XMLHttpRequest.DONE) {
            var data;
            var contentType = doc.getResponseHeader("Content-Type");

            if (params==1) {
                data = doc.responseXML.documentElement;
            }
            else {
                data = doc.responseText;
            }
//            var dbg = doc.responseText;
//            console.log(dbg);
            callback(data);
        }
    }

    doc.open(method, url);
    if(sid.length>0 && params==1) {
        // Google Finance ignore SID/LSID
        //console.log("Authorization GoogleLogin auth=" + sid);
        doc.setRequestHeader("Authorization", "GoogleLogin auth=" + sid);
        // Specifying a version
        doc.setRequestHeader("GData-Version", "2");
    }

    if(params<2) {
        //console.log("Sending: " + params);
        doc.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        doc.send();
    } else {
        doc.send();
    }
}

//////////////////////////////////////
// Parse Portfolio
//////////////////////////////////////

function parsePortfolio(data) {
    //try {
        //console.log("DATA: " + data);

        // 2) XML DOM
        var pfoLength = data.childNodes[8].firstChild.nodeValue;
        //console.log("pfo.length="+pfoLength);

        // <entry>
        for (var i=0; i<pfoLength; i++) {
            var pfoEtag        = data.childNodes[11+i].attributes[0].nodeValue;
            var pfoId          = data.childNodes[11+i].childNodes[0].firstChild.nodeValue;      // 1,2,3...

            var pfoName        = data.childNodes[11+i].childNodes[4].firstChild.nodeValue;      // Title
            var pfoFeedLink    = data.childNodes[11+i].childNodes[7].attributes[0].nodeValue;   // Link of position
            var currency       = data.childNodes[11+i].childNodes[8].attributes[0].nodeValue;
            var pfoGainPercent = data.childNodes[11+i].childNodes[8].attributes[1].nodeValue;
            var pfoRtnYTD      = data.childNodes[11+i].childNodes[8].attributes[9].nodeValue;

            // Push to pfoModel
            if (i<model.count) {
                model.set(i, {
                             "name": pfoName,
                             "feedLink": pfoFeedLink,
                             "excerpt": "-",
                             "num": 0
                });
            }
            else {
                //pfoCModel.append(false, false, 0, pfoName, pfoFeedLink, "-");
                model.append({
                             "local": 0,
                             "name": pfoName,
                             "feedLink": pfoFeedLink,
                             "isYahoo": false,
                             "excerpt": "-",
                             "num": 0
                });
            }

            // Retrieve number of quotes for each portfolio... this is kinda redundant but do with it for now.
            var idx = i + 1;
            itemsURL = pfoId + "/positions";
            loadPortfolioNum(i);

            /*
            console.log("<Portfolio.entry>");
            console.log("pfo.name"+pfoName);
            console.log("pfo.etag="+pfoEtag);
            console.log("pfo.Id="+pfoId);
            console.log("pfo.feedLink="+pfoFeedLink);
            console.log("currency="+currency);
            console.log("pfo.gainPercent="+pfoGainPercent);
            console.log("pfo.rtnYTD="+pfoRtnYTD);
            //*/
        }

    //}catch(err) {
    //    addError("Error: " + err);
    //}
}

function parsePortfolioNum(data, pfoIdx) {
    var posLength = data.childNodes[7].firstChild.nodeValue;
    var symName = new String("");

    for (var i=0; i< ((posLength>3) ? 3 : posLength) ; i++) {
        symName += data.childNodes[10+i].childNodes[7].attributes[2].nodeValue + ", ";
    }

    var lastComma = symName.lastIndexOf(",");
    symName = symName.substring(0, lastComma);
    symName +=  " ...";

    // Push to pfoModel
    //console.log("idx="+pfoIdx+" num="+posLength);
    if (pfoIdx<model.count) {
        model.set(pfoIdx, {
                  "num": posLength,
                  "excerpt": symName
        });
    }
}

//////////////////////////////////////
// Position Loading
//////////////////////////////////////

function loadOnePosition(posFeedLink, pfoLocal, pfoIsYahoo, loadPosFromFile) {
    // activePos is not set upon first entry
    if (posFeedLink=="") {
        return;
    }

    // Replace http with https
    posFeedLink = posFeedLink.replace("http:", "https:");

    //console.log("loadOnePosition: " + posFeedLink + " " + pfoLocal + " " + pfoIsYahoo + " " + loadPosFromFile);

    itemsURL = posFeedLink+"?returns=true";
    loadPosition();
}

function loadPosition() {
    try {
        doWebRequest("GET", itemsURL, 1, parsePosition, 2);
    } catch(err) {
        //showError("Error while loading position: " + err, 1);
    }
}

//////////////////////////////////////
// Parsing
//////////////////////////////////////
function parsePosition(data) {
    //try {
        var posLength = data.childNodes[7].firstChild.nodeValue;

        console.log("pos.length="+posLength);
        var quoteListGoogle = "";
        var quoteListYahoo = "";

        // Improved error handling
        if (posLength==0) {
            //showError("Cannot load portfolio.\n\nCheck if you have portfolio selected.\nCreate one on Google if you don't have any.", 1);
            return;
        }
        else {
            for (var i=0; i<posLength; i++) {
                var symObj = {
                "shareGainPercent" : sprintf("%.2f", 100*data.childNodes[10+i].childNodes[6].attributes[0].nodeValue), // Same as returnOverall
                "symRtnYTD"      : sprintf("%.2f", 100*data.childNodes[10+i].childNodes[6].attributes[8].nodeValue),
                "symShare"       : data.childNodes[10+i].childNodes[6].attributes[9].nodeValue,
                "symExg"         : data.childNodes[10+i].childNodes[7].attributes[0].nodeValue,
                "symName"        : data.childNodes[10+i].childNodes[7].attributes[2].nodeValue,

                "shareCost"     : "0",
                "shareValue"    : "0",
                "shareDayGain"  : "0",
                "shareGain"     : "0"

                // Don't parse for now...
                //"symEtag"        : data.childNodes[10+i].attributes[0].nodeValue,
                //"symFeedLink"    : data.childNodes[10+i].childNodes[5].attributes[0].nodeValue,   // transaction link
                //"symFullName"    : data.childNodes[10+i].childNodes[7].attributes[1].nodeValue,
            };

            // costBasis, gain, mktValue. Only those who have TX records are available
            if (data.childNodes[10+i].childNodes[6].childNodes.length==4) {
                symObj.shareCost    = data.childNodes[10+i].childNodes[6].childNodes[0].firstChild.attributes[0].nodeValue;
                symObj.shareDayGain = data.childNodes[10+i].childNodes[6].childNodes[1].firstChild.attributes[0].nodeValue;
                symObj.shareGain   = data.childNodes[10+i].childNodes[6].childNodes[2].firstChild.attributes[0].nodeValue;
                symObj.shareValue   = data.childNodes[10+i].childNodes[6].childNodes[3].firstChild.attributes[0].nodeValue;
            }

            // JSON Parsing, parsed data stored in global jsonObj.
            // Push needs to be done in parseJSON to keep the program synchronous.
            loadQuoteHeader(symObj, i);
            quoteListGoogle = quoteListGoogle + "," + symObj.symName + ":" + symObj.symExg;
            quoteListYahoo  = quoteListYahoo + "+" + convertExchangeForYahoo(symObj.symName, symObj.symExg);
        }

        // Take out leading +
        quoteListGoogle = quoteListGoogle.replace(/^\,/, "");
        quoteListYahoo = quoteListYahoo.replace(/^\+/, "");

        loadAllQuotes(quoteListGoogle);
        loadYahooQuote(quoteListYahoo);

    //}catch(err) {
    //    addError("Error: " + err);
    //}
        }
}

function loadQuoteHeader(symObj, idx) {
    if (idx >= model.count) {
        model.append({
                     //"idx":            idx,
                     //"id":             symObj.symId,
                     //"rtnYTD":         symObj.symRtnYTD,
                     "share":          symObj.symShare,
                     "shareCost":      symObj.shareCost,
                     "shareDayGain":   symObj.shareDayGain,
                     "shareGain":      symObj.shareGain,
                     "shareValue":     symObj.shareValue,
                     "shareGainPercent": symObj.shareGainPercent,

                     "exchange":       "-",
                     "fullName":       "-",
                     "name":           "Loading",

                     "quotePrice":     "-",

                     "quoteChgColor":  "green",
                     "quoteChg":       "-",
                     "quoteChgPtg":    "-",
                     "quoteVol":       "-",
                     "quoteAvgVol":    "-",
                     "quoteMktCap":    "-",

                     "quoteDayHi":     "-",
                     "quoteDayLo":     "-",
                     "quote52wHi":     "-",
                     "quote52wLo":     "-",

                     "quoteEps":       "-",
                     "quoteBeta":      "-",
                     "quotePe":        "-",
                     "quoteType":      "-",

                     "quoteAsk":       "-",
                     "quoteBid":       "-"
        });
    }
    else {
        model.set(idx, {
            "share":          symObj.symShare,
            "shareGain":      symObj.shareGain,
            "shareCost":      symObj.shareCost,
            "shareDayGain":   symObj.shareDayGain,
            "shareValue":     symObj.shareValue,
            "shareGainPercent": symObj.shareGainPercent
            //"rtnYTD":         symObj.symRtnYTD
        });
    }
}

function loadAllQuotes(quoteList) {
    itemsURL = "http://www.google.com/finance/info?client=ig&infotype=infoquoteall&q=" + quoteList;
    try {
        doWebRequest("GET", itemsURL, 2, parseJSONAll, 3);
    } catch(err) {
        //showError("Error while loading g_quote: " + err, 1);
    }
}

function parseJSONAll(data) {
    // Remove comment // at the beginning
    data = removeComment(data);

    // eval is unsafe, but JSON.parse is prone to fail
    var jsonObj = eval("(" + data + ")");

    if (jsonObj==null || typeof(jsonObj)==undefined) {
        return;
    }

    for (var i=0; i<model.count; i++) {

        var quoteChgColor;
        //var chgSymbol = jsonObj[0].c.match(/^\-/);
        if (jsonObj[i].c.indexOf("-")==0) { //chgSymbol != null) {
            quoteChgColor = (quoteChgColorMode) ? "green" : "red";
        }
        else {
            quoteChgColor = (quoteChgColorMode) ? "red" : "green";
        }

        model.set(i, {
                     "exchange":       (jsonObj[i].e   =="") ? "-" : jsonObj[i].e   ,    //symObj.symExg,
                     "fullName":       (jsonObj[i].name=="") ? "-" : jsonObj[i].name, //symObj.symFullName,
                     "name":           (jsonObj[i].t   =="") ? "-" : jsonObj[i].t   ,    //symObj.symName,
                     "quotePrice":     (jsonObj[i].l   =="") ? "-" : jsonObj[i].l   ,
                     "quoteChgColor":  (quoteChgColor  =="") ? "-" : quoteChgColor  ,
                     "quoteChg":       (jsonObj[i].c   =="") ? "-" : jsonObj[i].c   ,
                     "quoteChgPtg":    (jsonObj[i].cp  =="") ? "-" : jsonObj[i].cp  ,
                     "quoteVol":       (jsonObj[i].vo  =="") ? "-" : jsonObj[i].vo  ,
                     "quoteAvgVol":    (jsonObj[i].avvo=="") ? "-" : jsonObj[i].avvo,
                     "quoteMktCap":    (jsonObj[i].mc  =="") ? "-" : jsonObj[i].mc  ,
                     "quoteDayHi":     (jsonObj[i].hi  =="") ? "-" : jsonObj[i].hi  ,
                     "quoteDayLo":     (jsonObj[i].lo  =="") ? "-" : jsonObj[i].lo  ,
                     "quote52wHi":     (jsonObj[i].hi52=="") ? "-" : jsonObj[i].hi52,
                     "quote52wLo":     (jsonObj[i].lo52=="") ? "-" : jsonObj[i].lo52,
                     "quoteEps":       (jsonObj[i].eps =="") ? "-" : jsonObj[i].eps ,
                     "quoteBeta":      (jsonObj[i].beta=="") ? "-" : jsonObj[i].beta,
                     "quotePe":        (jsonObj[i].pe  =="") ? "-" : jsonObj[i].pe  ,
                     "quoteType":      (jsonObj[i].type=="") ? "-" : jsonObj[i].type
        });
    }
}

function loadYahooQuote(quoteList) {
    try {
        itemsURL =   "http://download.finance.yahoo.com/d/quotes.csv?s="+ quoteList + "&f=b2b3";
        doWebRequest("GET", itemsURL, 2, parseCSV, 3);
    } catch(err) {
        //showError("Error while loading y_quote: " + err, 1);
    }
}


// Parse Yahoo feed
function parseCSV(data) {
    //console.log(data);

    // Array[count*i+j]
    var csvObj = CSVToArray(data);
    //console.log("parseCSV:" + csvObj.length);

    // b2, b3: ask, bid (real-time)
    if ( csvObj.length != ( model.count*2 ))  {
        return;
    }
    else {
        for (var i=0; i<model.count; i++) {
            console.log("error");
            model.set(i, {
                      "quoteAsk": (csvObj[i][0]=="N/A"||csvObj[i][0]=="") ? "-" : csvObj[i][0],
                      "quoteBid": (csvObj[i][1]=="N/A"||csvObj[i][1]=="") ? "-" : csvObj[i][1]
            });
        }
    }
}

function convertExchangeForYahoo (name, exg) {
    // No need to do this replacement, Yahoo quote doesn't understand.
//    if (name.indexOf(".")==0)
//        return name.replace(".", "^");

    //console.log(name + exg);
    if (exg=="NYSE" || exg=="NASDAQ") { return name; }
    else if (exg=="OTC")              { return (name + "." + "OB"); }
    else if (exg=="AMEX")             { return (name + "." + "OB"); }
    else if (exg=="TSXV")             { return (name + "." + "V");  }
    else if (exg=="TSX")              { return (name + "." + "TO"); }
    else if (exg=="LON")              { return (name + "." + "L"); }
    // Australia
    else if (exg=="ASX")              { return (name + "." + "AX"); }
    // Asian
    else if (exg=="TPE")              { return (name + "." + "TW"); }
    else if (exg=="HKG")              { return (name + "." + "HK"); }
    else if (exg=="SHA")              { return (name + "." + "SS"); }
    else if (exg=="SHE")              { return (name + "." + "SZ"); }
    else if (exg=="SEO")              { return (name + "." + "KS"); }
    else                              { return name; }
}

function CSVToArray( strData, strDelimiter ){
// Check to see if the delimiter is defined. If not,
// then default to comma.
strDelimiter = (strDelimiter || ",");

// Create a regular expression to parse the CSV values.
var objPattern = new RegExp(
(
// Delimiters.
"(\\" + strDelimiter + "|\\r?\\n|\\r|^)" +

// Quoted fields.
"(?:\"([^\"]*(?:\"\"[^\"]*)*)\"|" +

// Standard fields.
"([^\"\\" + strDelimiter + "\\r\\n]*))"
),
"gi"
);

// Create an array to hold our data. Give the array
// a default empty first row.
var arrData = [[]];

// Create an array to hold our individual pattern
// matching groups.
var arrMatches = null;


// Keep looping over the regular expression matches
// until we can no longer find a match.
while (arrMatches = objPattern.exec( strData )){

// Get the delimiter that was found.
var strMatchedDelimiter = arrMatches[ 1 ];

// Check to see if the given delimiter has a length
// (is not the start of string) and if it matches
// field delimiter. If id does not, then we know
// that this delimiter is a row delimiter.
if (
strMatchedDelimiter.length &&
(strMatchedDelimiter != strDelimiter)
){

// Since we have reached a new row of data,
// add an empty row to our data array.
arrData.push( [] );

}


// Now that we have our delimiter out of the way,
// let's check to see which kind of value we
// captured (quoted or unquoted).
if (arrMatches[ 2 ]){

// We found a quoted value. When we capture
// this value, unescape any double quotes.
var strMatchedValue = arrMatches[ 2 ].replace(
new RegExp( "\"\"", "g" ),
"\""
);

} else {

// We found a non-quoted value.
var strMatchedValue = arrMatches[ 3 ];

}


// Now that we have our value string, let's add
// it to the data array.
arrData[ arrData.length - 1 ].push( strMatchedValue );
}

// Return the parsed data.
return( arrData );
}

function sprintf()
{
   if (!arguments || arguments.length < 1 || !RegExp)
   {
      return;
   }
   var str = arguments[0];
   var re = /([^%]*)%('.|0|\x20)?(-)?(\d+)?(\.\d+)?(%|b|c|d|u|f|o|s|x|X)(.*)/;
   var a = [];
   var b = [];
   var numSubstitutions = 0;
   var numMatches = 0;
   while (a = re.exec(str))
   {
      var leftpart = a[1], pPad = a[2], pJustify = a[3], pMinLength = a[4];
      var pPrecision = a[5], pType = a[6], rightPart = a[7];

      numMatches++;
      if (pType == '%')
      {
         subst = '%';
      }
      else
      {
         numSubstitutions++;
         if (numSubstitutions >= arguments.length)
         {
            alert('Error! Not enough function arguments (' + (arguments.length - 1)
               + ', excluding the string)\n'
               + 'for the number of substitution parameters in string ('
               + numSubstitutions + ' so far).');
         }
         var param = arguments[numSubstitutions];
         var pad = '';
                if (pPad && pPad.substr(0,1) == "'") pad = leftpart.substr(1,1);
           else if (pPad) pad = pPad;
         var justifyRight = true;
                if (pJustify && pJustify === "-") justifyRight = false;
         var minLength = -1;
                if (pMinLength) minLength = parseInt(pMinLength);
         var precision = -1;
                if (pPrecision && pType == 'f')
                   precision = parseInt(pPrecision.substring(1));
         var subst = param;
         switch (pType)
         {
         case 'b':
            subst = parseInt(param).toString(2);
            break;
         case 'c':
            subst = String.fromCharCode(parseInt(param));
            break;
         case 'd':
            subst = parseInt(param) ? parseInt(param) : 0;
            break;
         case 'u':
            subst = Math.abs(param);
            break;
         case 'f':
            subst = (precision > -1)
             ? Math.round(parseFloat(param) * Math.pow(10, precision))
              / Math.pow(10, precision)
             : parseFloat(param);
            break;
         case 'o':
            subst = parseInt(param).toString(8);
            break;
         case 's':
            subst = param;
            break;
         case 'x':
            subst = ('' + parseInt(param).toString(16)).toLowerCase();
            break;
         case 'X':
            subst = ('' + parseInt(param).toString(16)).toUpperCase();
            break;
         }
         var padLeft = minLength - subst.toString().length;
         if (padLeft > 0)
         {
            var arrTmp = new Array(padLeft+1);
            var padding = arrTmp.join(pad?pad:" ");
         }
         else
         {
            var padding = "";
         }
      }
      str = leftpart + padding + subst + rightPart;
   }
   return str;
}                      

function removeComment(data) {
    data = data.replace(/\/\//, "");
    return data;
}

