import QtQuick 1.0

Rectangle {
    id: container
    width: parent.width
    height: 50
    color: "#E4F5FF"
    radius: 5
    smooth: true

    property int textSize: 12
    property alias text: label.text
    property bool textBold: false
    property bool textElide: false

    property color textColor: "#396AB3"

    signal clicked

    Text {
        id: label;
        width: parent.width
        height: parent.height
        color: textColor
        font.bold: textBold
        font.pixelSize: textSize
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        elide: (textElide) ? Text.ElideRight : Text.ElideNone
    }
}
