#include "pfomodel.h"

PfoItem::PfoItem(const bool local, const bool isYahoo, const int num, const QString &name, const QString &feedLink, const QString &excerpt, QObject *parent) :
  ListItem(parent), m_local(local), m_isYahoo(isYahoo), m_num(num), m_name(name), m_feedLink(feedLink), m_excerpt(excerpt)
{
}

QHash<int, QByteArray> PfoItem::roleNames() const
{
  QHash<int, QByteArray> names;
  names[LocalRole]    = "local";
  names[IsYahooRole]  = "isYahoo";
  names[NumRole]      = "num";
  names[NameRole]     = "name";
  names[FeedLinkRole] = "feedLink";
  names[ExcerptRole]  = "excerpt";
  return names;
}

QVariant PfoItem::data(int role) const
{
  switch(role) {
  case LocalRole:
    return local();
  case IsYahooRole:
    return isYahoo();
  case NumRole:
    return num();
  case NameRole:
    return name();
  case FeedLinkRole:
    return feedLink();
  case ExcerptRole:
    return excerpt();
  default:
    return QVariant();
  }
}

