#include "filehandler.h"

FileHandler::FileHandler(QObject *parent) :
    QObject(parent)
{
    //cfgDir = "/home/user/.stockona/";
}

void FileHandler::debugPfo() {
    for (int i=0; i<pfoModel.pfoName.length(); i++) {
        #ifdef DBG
        qDebug() << i << "="
                 << pfoModel.pfoName[i].toString() << ":"
                 << pfoModel.pfoDesc[i].toString() << ":"
                 << pfoModel.pfoIsYahoo[i].toBool() ; //<< ":"
                 //<< pfoModel.pfoNum[i].toInt();
        #endif
    }
}

// Overloaded function to eliminate appendPfo()
Q_INVOKABLE int FileHandler::storePfo(QString name, QString desc, bool isYahoo)
{
    #ifdef DBG
    qDebug() << "C_Info: storePfo() " << name << " " << desc << " " << isYahoo;
    #endif
    pfoModel.pfoName.append(name);
    pfoModel.pfoDesc.append(desc);
    pfoModel.pfoIsYahoo.append(isYahoo);

    QFile f( "/home/user/.stockona/portfolio.cfg" );

    if( !f.open( QIODevice::WriteOnly ) )
    {
        #ifdef DBG
        qDebug() << "Failed to open for write.";
        #endif

        return -1;
    }

    QTextStream ts( &f );

    if (!pfoModel.pfoName.isEmpty()) {
        for (int i=0; i < pfoModel.pfoName.count(); i++) {
            ts << pfoModel.pfoName[i].toString() << ":" << pfoModel.pfoDesc[i].toString() << ":" << pfoModel.pfoIsYahoo[i].toBool() << endl;
            #ifdef DBG
            qDebug() << "C_Info: " << pfoModel.pfoName[i].toString() << ":" << pfoModel.pfoDesc[i].toString() << ":" << pfoModel.pfoIsYahoo[i].toBool();
            #endif
        }
    }

    f.close();

    return 0;
}

Q_INVOKABLE int FileHandler::storePfoAll()
{
    #ifdef DBG
    qDebug() << "C_Info: storePfoAll()";
    #endif

    QFile f( "/home/user/.stockona/portfolio.cfg" );

    if( !f.open( QIODevice::WriteOnly ) )
    {
        #ifdef DBG
        qDebug() << "Failed to open for write.";
        #endif

        return -1;
    }

    QTextStream ts( &f );

    if (!pfoModel.pfoName.isEmpty()) {
        for (int i=0; i < pfoModel.pfoName.count(); i++) {
            ts << pfoModel.pfoName[i].toString() << ":" << pfoModel.pfoDesc[i].toString() << ":" << pfoModel.pfoIsYahoo[i].toBool() << endl;
            #ifdef DBG
            qDebug() << "C_Info: " << pfoModel.pfoName[i].toString() << ":" << pfoModel.pfoDesc[i].toString() << ":" << pfoModel.pfoIsYahoo[i].toBool();
            #endif
        }
    }

    f.close();

    return 0;
}

Q_INVOKABLE int FileHandler::loadPfo()
{
    QDir dir("/home/user/.stockona/");
    if (!dir.exists()) {
        dir.mkpath("/home/user/.stockona/");
    }

    #ifdef DBG
    qDebug() << "C_Info: loadPfo --->";
    #endif

    QFile f( "/home/user/.stockona/portfolio.cfg" );

    pfoModel.pfoName.clear();
    pfoModel.pfoDesc.clear();
    pfoModel.pfoIsYahoo.clear();

    if( !f.exists() )
    {
        #ifdef DBG
        qDebug() << "C_Info: Local portfolio does not exist.";
        #endif

        return -1;
    }

    if( !f.open( QIODevice::ReadOnly ) )
    {
        #ifdef DBG
        qDebug() << "C_Info: Failed to open for read.";
        #endif

        return -1;
    }

    QTextStream ts( &f );

    QStringList strList;
    //QStringList::const_iterator constIterator;

    while ( !ts.atEnd() ) {
        strList = ts.readLine().split(":");

        if (strList.length()==3) {
            //for (constIterator = strList.constBegin(); constIterator != strList.constEnd(); ++constIterator) {
            //qDebug() << (*constIterator).toLocal8Bit().constData();
            //if (constIterator==strList.constBegin())
            //    pfoName.append( (*constIterator).toLocal8Bit().constData() );
            //else
            //    pfoNum.append( (*constIterator).toLocal8Bit().constData() );
            for (int i=0; i<strList.length(); i++) {
                //qDebug() << "C_Info: " << strList[i].toLocal8Bit().constData();
                if (i==0)
                    pfoModel.pfoName.append( strList[i].toLocal8Bit().constData() );
                else if (i==1)
                    pfoModel.pfoDesc.append( strList[i].toLocal8Bit().constData() );
                else
                    pfoModel.pfoIsYahoo.append( strList[i].toLocal8Bit().constData() );
            }
        }
        else {
            // Fix format
            //f.remove();
            #ifdef DBG
            qDebug() << "C_Info: Error in loading local portfolio.";
            #endif

            return -2;
        }
    }

    f.close();

    for (int i=0; i<pfoModel.pfoName.length(); i++) {
        loadPosNum(i);
    }

    debugPfo();

    return 0;
}

Q_INVOKABLE void FileHandler::setPfo(int idx, QString name, QString desc, bool isYahoo) {
    #ifdef DBG
    qDebug() << "C_Info: Append: " << name << " " << desc << " " << isYahoo << "to" << idx;
    #endif
    pfoModel.pfoName.replace(idx, name);
    pfoModel.pfoDesc.replace(idx, desc);
    pfoModel.pfoIsYahoo.replace(idx, isYahoo);
}

Q_INVOKABLE void FileHandler::removePfo(int idx) {
    #ifdef DBG
    qDebug() << "C_Info: Remove portfolio entry " << idx;
    #endif
    pfoModel.pfoName.removeAt(idx);
    pfoModel.pfoDesc.removeAt(idx);
    pfoModel.pfoIsYahoo.removeAt(idx);
    pfoModel.pfoNum.removeAt(idx);
}

void FileHandler::updatePfoNum(int idx, int num) {
    if (idx < pfoModel.pfoNum.length())
        pfoModel.pfoNum[idx] = num;
    else
        pfoModel.pfoNum.append(num);
}

Q_INVOKABLE int FileHandler::deletePfo()
{
    QFile f( "portfolio.cfg" );

    if( !f.exists() )
    {
        #ifdef DBG
        qDebug() << "Local portfolio does not exist.";
        #endif

        return -1;
    }

    f.remove();
    #ifdef DBG
    qDebug() << "Delete local portfolio.";
    #endif

    f.close();

    return 0;
}

/*
  Position
*/

int FileHandler::loadPosNum(int idx)
{
    QString filename = "/home/user/.stockona/";
    filename.append(QString::number(idx));
    filename.append(".pos");

    QFile f( filename );

    if( !f.exists() )
    {
        #ifdef DBG
        qDebug() << "C_Info: Position " << filename << " does not exist.";
        #endif
        updatePfoNum(idx, 0);
        return -1;
    }

    if( !f.open( QIODevice::ReadOnly ) )
    {
        #ifdef DBG
        qDebug() << "C_Info: Failed to open position " << filename << " for read.";
        #endif
        updatePfoNum(idx, 0);
        return -1;
    }

    QTextStream ts( &f );

    QStringList strList;

    int lineCount = 0;

    while ( !ts.atEnd() ) {
        strList = ts.readLine().split(":");
        lineCount++;
    }

    f.close();

    updatePfoNum(idx, lineCount);

    return 0;
}

Q_INVOKABLE int FileHandler::loadPos(int idx)
{
    QString filename = "/home/user/.stockona/";
    filename.append(QString::number(idx));
    filename.append(".pos");

    #ifdef DBG
    qDebug() << "C_Info: loadPos ---> " << filename;
    #endif

    QFile f( filename );

    posSymbol.clear();
    posExg.clear();
    posShare.clear();
    posCost.clear();
    posStop.clear();

    if( !f.exists() )
    {
        #ifdef DBG
        qDebug() << "C_Info: Position " << filename << " does not exist.";
        #endif
        // Set pfo's num to 0
        updatePfoNum(idx, 0);

        return -1;
    }

    if( !f.open( QIODevice::ReadOnly ) )
    {
        #ifdef DBG
        qDebug() << "C_Info: Failed to open position " << filename << " for read.";
        #endif
        // Set pfo's num to 0
        updatePfoNum(idx, 0);

        return -1;
    }

    QTextStream ts( &f );

    QStringList strList;

    while ( !ts.atEnd() ) {
        strList = ts.readLine().split(":");

        if (strList.length()==6) {
            for (int i=0; i<strList.length(); i++) {
                //qDebug() << "C_Info: " << strList[i].toLocal8Bit().constData();
                if (i==0)
                    posSymbol.append( strList[i].toLocal8Bit().constData() );
                else if (i==1)
                    posExg.append( strList[i].toLocal8Bit().constData() );
                else if (i==2)
                    posShare.append( strList[i].toLocal8Bit().constData() );
                else if (i==3)
                    posCost.append( strList[i].toLocal8Bit().constData() );
                else if (i==4)
                    posStop.append( strList[i].toLocal8Bit().constData() );
            }
        }
        else {
            // Fix format
            //f.remove();
            #ifdef DBG
            qDebug() << "C_Info: Error in loading local position.";
            #endif

            return -2;
        }
    }

    debugPos();

    f.close();

    updatePfoNum(idx, posSymbol.length());

    return 0;
}

// Overloaded storePos
Q_INVOKABLE int FileHandler::storePos(int idx, QString symbol, QString exchange, int share, int cost, int stop)
{
    #ifdef DBG
    qDebug() << "C_Info: storePos() " << symbol << " " << exchange << " " << share << " " << cost << " " << stop;
    #endif

    posSymbol.append(symbol);
    posExg.append(exchange);
    posShare.append(share);
    posCost.append(cost);
    posStop.append(stop);

    QString filename = "/home/user/.stockona/";
    filename.append(QString::number(idx));
    filename.append(".pos");
    #ifdef DBG
    qDebug() << "C_Info: storePos() into " << filename;
    #endif

    QFile f( filename );

    if( !f.open( QIODevice::WriteOnly ) )
    {
        #ifdef DBG
        qDebug() << "Failed to open " << filename << " for write.";
        #endif

        return -1;
    }

    QTextStream ts( &f );

    if (!posSymbol.isEmpty()) {
        for (int i=0; i < posSymbol.count(); i++) {
            ts << posSymbol[i].toString() << ":"
               << posExg[i].toString() << ":"
               << posShare[i].toInt() << ":"
               << posCost[i].toInt() << ":"
               << posStop[i].toInt() << ":"
               << "0" << endl;
        }
    }

    f.close();

    if (pfoModel.pfoNum.length()>0 && idx < pfoModel.pfoNum.length()) {
        pfoModel.pfoNum[idx] = posSymbol.length();
    }

    return 0;
}

Q_INVOKABLE int FileHandler::storePosAll(int idx)
{
    QString filename = "/home/user/.stockona/";
    filename.append(QString::number(idx));
    filename.append(".pos");
    #ifdef DBG
    qDebug() << "C_Info: storePosAll() into " << filename;
    #endif

    QFile f( filename );

    if( !f.open( QIODevice::WriteOnly ) )
    {
        #ifdef DBG
        qDebug() << "Failed to open " << filename << " for write.";
        #endif

        return -1;
    }

    //debugPos();

    QTextStream ts( &f );

    if (!posSymbol.isEmpty()) {
        for (int i=0; i < posSymbol.count(); i++) {
            ts << posSymbol[i].toString() << ":"
               << posExg[i].toString() << ":"
               << posShare[i].toInt() << ":"
               << posCost[i].toInt() <<  ":"
               << posStop[i].toInt() << ":"
               << "0" << endl;
        }
    }

    f.close();

    if (pfoModel.pfoNum.length()>0 && idx < pfoModel.pfoNum.length()) {
        pfoModel.pfoNum[idx] = posSymbol.length();
    }

    return 0;
}

Q_INVOKABLE void FileHandler::setPos(int idx, QString symbol, QString exchange, int share, int cost, int stop)
{
    #ifdef DBG
    qDebug() << "C_Info: Append: " << symbol << " " << exchange << " " << share << " " << cost << " " << stop;
    #endif
    posSymbol.replace(idx, symbol);
    posExg.replace(idx, exchange);
    posShare.replace(idx, share);
    posCost.replace(idx, cost);
    posStop.replace(idx, stop);
}

Q_INVOKABLE void FileHandler::removePos(int idx)
{
    #ifdef DBG
    qDebug() << "C_Info: Remove pos entry " << idx;
    #endif
    posSymbol.removeAt(idx);
    posExg.removeAt(idx);
    posShare.removeAt(idx);
    posCost.removeAt(idx);
    posStop.removeAt(idx);
}

Q_INVOKABLE void FileHandler::removePosFile(int idx)
{
    QString filename = "/home/user/.stockona/";
    filename.append(QString::number(idx));
    filename.append(".pos");
    QFile::remove(filename);
}

void FileHandler::debugPos() {
    for (int i=0; i<posSymbol.count(); i++) {
        #ifdef DBG
        qDebug() << i << "="
                 << posSymbol[i].toString() << ":"
                 << posExg[i].toString() << ":"
                 << posShare[i].toInt() << ":"
                 << posCost[i].toInt() << ":"
                 << posStop[i].toInt();
        #endif
    }
}


// Utility function
QVariantList FileHandler::calcPerformance (int i, int price) {
    QVariantList perfData;

    int cost = posCost[i].toInt() * posShare[i].toInt();
    int value = price * posShare[i].toInt();

    perfData.append(value - cost); // gain
    perfData.append(cost);         // cost
    perfData.append(value);        // value

    // gain percentage
    if (cost==0) {
        perfData.append("-");
    }
    else {
        perfData.append((value - cost)/cost);
    }


    #ifdef DBG
    qDebug() << "(cost, value, gainPtg)=" << cost << " " << value;
    #endif

    return perfData;
}
