 /****************************************************************************
 **
 ** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
 ** All rights reserved.
 ** Contact: Nokia Corporation (qt-info@nokia.com)
 **
 ** This file is part of the examples of the Qt Toolkit.
 **
 ** $QT_BEGIN_LICENSE:BSD$
 ** You may use this file under the terms of the BSD license as follows:
 **
 ** "Redistribution and use in source and binary forms, with or without
 ** modification, are permitted provided that the following conditions are
 ** met:
 **   * Redistributions of source code must retain the above copyright
 **     notice, this list of conditions and the following disclaimer.
 **   * Redistributions in binary form must reproduce the above copyright
 **     notice, this list of conditions and the following disclaimer in
 **     the documentation and/or other materials provided with the
 **     distribution.
 **   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
 **     the names of its contributors may be used to endorse or promote
 **     products derived from this software without specific prior written
 **     permission.
 **
 ** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 ** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 ** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 ** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 ** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 ** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 ** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 ** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 ** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 ** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
 ** $QT_END_LICENSE$
 **
 ****************************************************************************/

 import QtQuick 1.0

 Rectangle {
     id: container

     property alias text: label.text
     property color textColor: "black"
     property bool  textBold: false
     property int  textSize: 24

     property color lightColor: "#F6F6F6"
     property color darkColor:  "#DADADA"
     property color pressColor: "#808080"

     signal clicked

     width: label.width + 40; height: label.height + 8

     smooth: true
     radius: 10

     gradient: Gradient {
         //GradientStop { id: gradientStop; position: 0.0; color: palette.light }
         //GradientStop { position: 1.0; color: palette.button }
         GradientStop { id: gradientStop; position: 0.0; color: container.lightColor }
         GradientStop { position: 1.0; color: container.darkColor }
     }

     // Maemo doesn't seem to support this
     //SystemPalette { id: palette }

     MouseArea {
         id: mouseArea
         anchors.fill: parent
         onClicked: { container.clicked() }
     }

     Text {
         id: label
         color: textColor
         font.bold: textBold
         font.pixelSize: textSize
         anchors.centerIn: parent
     }

     states: State {
         name: "pressed"
         when: mouseArea.pressed
         //PropertyChanges { target: gradientStop; color: palette.dark }
         PropertyChanges { target: gradientStop; color: container.pressColor }
     }
 }
