#include <QDeclarativeContext>
#include <QDeclarativeEngine>
#include <QtGui/QApplication>
#include "qmlapplicationviewer.h"
#include "windowhelper.h"
#include "filehandler.h"
#include "networkhelper.h"
//#include "pfomodel.h"
//#include "QString"

#ifdef HAVE_GLWIDGET

#include <QGLWidget>

#endif

//ListModel* createPfoModel() {
//  ListModel *model = new ListModel(new PfoItem, qApp);
//  QString name = "CPfoModel";
//  QString feedLink = "xxx";
//  QString excerpt = "Test";
//  model->append(new PfoItem(false, false, 0, name, feedLink, excerpt));

//  return model;
//}

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    QmlApplicationViewer viewer;

//#ifdef HAVE_GLWIDGET
//    QGLWidget *glWidget = new QGLWidget(&viewer);
//    viewer.setViewport(glWidget);
//#endif

    WindowHelper *windowHelper = new WindowHelper();
    viewer.rootContext()->setContextProperty("windowHelper", windowHelper);
    FileHandler *fileHandler = new FileHandler();
    viewer.rootContext()->setContextProperty("fileHandler", fileHandler);

    // Share QML NetworkAccessManger for QT C++ network operations
    NetworkHelper *nwHelper = new NetworkHelper();
    QNetworkAccessManager * manager = viewer.rootContext()->engine()->networkAccessManager();
    nwHelper->setNetworkAccessManager(manager);
    //nwHelper->doWebRequest("POST", "https://www.google.com/accounts/ClientLogin?Email=&Passwd=", 0);

    // C++ ListModel
    //    viewer.rootContext()->setContextProperty("pfoCModel",  createPfoModel);

    viewer.setAttribute(Qt::WA_NoSystemBackground);
    viewer.viewport()->setAttribute(Qt::WA_NoSystemBackground);
    viewer.setAttribute(Qt::WA_OpaquePaintEvent);
    viewer.viewport()->setAttribute(Qt::WA_OpaquePaintEvent);

    viewer.setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
    viewer.setMainQmlFile(QLatin1String("qml/stockona/main.qml"));

#ifdef Q_OS_SYMBIAN
    viewer.showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    viewer.showFullScreen();
#elif defined(Q_WS_SIMULATOR)
    //viewer.showExpanded();
    viewer.showFullScreen();
#else
    // we don't want full screen on meego tablets at least
    viewer.showMaximized();
#endif


    return app.exec();
}
