/*
Log file
*/

import QtQuick 1.0

Rectangle {
    id: settingMenu
    width: 640//parent.width
    height: 480//parent.height
    color: "#B0D8FF"

    property alias username: usrNameInput.text
    property alias password: usrPwdInput.text
    property alias timer: updateFreqInput.text
    property bool usePortfolioView: false

    property int listFontSize: 28
    property int fontSize1: listFontSize - 2

    property color textInputBg: "#E2EFFC" //"#C2DEFA"
    property color breakBg: "#D5D5D5"

    // signal interface
    signal callPfo
    signal close

    Rectangle {
        id: background
        x: 2; y: 2; width: parent.width - x*2; height: parent.height - y*2
        color: "ivory"
        border.color: "orange"
        radius: 5
    }

    Column{
        id: menuGrid
        x:10
        y:10
        spacing: 10

        Row {
            spacing: 20

            // Update frequency
            Text {
                id: updateFreq
                font.bold: true
                font.pixelSize: listFontSize
                text: "Refresh (Seconds)"
            }
            Rectangle {
                id: updateFreqInputBG
                x: 2
                width: settingMenu.width - 20 - x
                height: usrNameInput.height

                color: textInputBg
                radius: 5
                border.width: 1
                border.color: "#aaa"
                smooth: true

                TextInput {
                    id: updateFreqInput
                    //maximumLength: 5
                    inputMask: "99999"
                    text: "5"
                    focus: parent.focus
                    font.pixelSize: fontSize1
                }

                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        if (!updateFreqInput.activeFocus) {
                            updateFreqInput.forceActiveFocus();
                            updateFreqInput.openSoftwareInputPanel();
                        } else {
                            updateFreqInput.focus = false;
                        }
                    }
                }
            }
        }

        // Line separator
        Rectangle {
            id: pfoViewSeparator
            width: settingMenu.width
            height: 2
            color: "#D5D5D5"
        }

        // Portfolio view
        Row {
            spacing: 20

            Text {
                id: pfoView
                font.bold: true
                font.pixelSize: listFontSize
                text: "Portfolio View"
            }

            Rectangle {
                id: pfoBG
                x: 2
                width: pfoView.height
                height: pfoView.height

                color: textInputBg
                radius: 5
                border.width: 1
                border.color: "#aaa"
                smooth: true

                Rectangle {
                    id: pfoSelectBG
                    x: 4
                    y: 4
                    width: pfoView.height - 2*x
                    height: pfoView.height - 2*y
                    radius: 5
                    smooth: true
                    visible: settingMenu.usePortfolioView
                    color: "#7DBFFF"
                }

                MouseArea {
                    id: pfoViewMouseArea
                    anchors.fill: parent

                    onClicked: {
                        settingMenu.usePortfolioView = !usePortfolioView
                    }
                }
            }
        }

        // Line separator
        Rectangle {
            id: usrNameSeparator
            width: settingMenu.width
            height: 2
            color: "#D5D5D5"
        }

        // Username
        Row {
            spacing: 20

            Text {
                id: usrName
                font.bold: true
                font.pixelSize: listFontSize
                text: "Username"
            }
            // Input bg
            Rectangle {
                id: usrInputBG
                x: 2
                width: settingMenu.width - 20 - x
                height: usrNameInput.height

                color: textInputBg
                radius: 5
                border.width: 1
                border.color: "#aaa"
                smooth: true

                TextInput {
                    id: usrNameInput
                    maximumLength: 30
                    focus: parent.focus
                    font.pixelSize: fontSize1
                }

                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        if (!usrNameInput.activeFocus) {
                            usrNameInput.forceActiveFocus();
                            usrNameInput.openSoftwareInputPanel();
                        } else {
                            usrNameInput.focus = false;
                        }
                    }
                }
            }
        }

        // Line separator
        Rectangle {
            id: usrPwdSeparator
            width: settingMenu.width
            height: 2
            color: "#D5D5D5"
        }

        // Password
        Row {
            spacing: 20

            Text {
                id: usrPwd
                font.bold: true
                font.pixelSize: listFontSize
                text: "Password"
            }
            // Input bg
            Rectangle {
                id: usrPwdInputBG
                x: 2
                width: settingMenu.width - 20 - x
                height: usrPwdInput.height

                color: textInputBg
                radius: 5
                border.width: 1
                border.color: "#aaa"
                smooth: true

                TextInput {
                    id: usrPwdInput
                    maximumLength: 30
                    focus: parent.focus
                    echoMode: TextInput.Password
                    font.pixelSize: fontSize1
                }

                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        if (!usrPwdInput.activeFocus) {
                            usrPwdInput.forceActiveFocus();
                            usrPwdInput.openSoftwareInputPanel();
                        } else {
                            usrPwdInput.focus = false;
                        }
                    }
                }
            }
        }

        // Line separator
        Rectangle {
            id: pfoRowBG
            width: settingMenu.width
            height: 2
            color: "#D5D5D5"
        }

        // Select profolio
        Row {
            x: 2
            width: settingMenu.width
            height: pfo.height
            spacing: 20

            Text {
                id: pfo
                font.bold: true
                font.pixelSize: listFontSize
                text: "Select Portfolio"
            }
            TextButton {
                id: pfoButton
                text: "Portfolio"

                onClicked: { settingMenu.callPfo(); }
            }
        }

        // Line separator
        Rectangle {
            id: ctrlRowBG
            width: settingMenu.width
            height: 2
            color: "#D5D5D5"
        }
    }

    BackButton {
        id: backButton
        anchors { bottom: parent.bottom; left: parent.left; leftMargin: 20; bottomMargin: 20; }
        focus: true
        width: 65
        height: 65
        onClicked: { settingMenu.close(); }
    }
    // Animation
   // Behavior on y { PropertyAnimation{duration: 1000} }

//    states:
//        State {
//        name: "hidden"
//        PropertyChanges {
//            target: settingMenu
//            y: 0 - settingMenu.height - 16
//        }
//    }
//    State {
//        name: "shown"
//        PropertyChanges {
//            target: settingMenu
//            y: 40
//        }
//    }

//    transitions: Transition {
//        SequentialAnimation {
//            PropertyAnimation {
//                target: settingMenu
//                properties: "y"
//                duration: 600
//                easing.type: "OutQuad"
//            }
//        }
//    }
}
