import QtQuick 1.0

Rectangle {
    id: container
    width: 640
    height: 480
    color: "#B0D8FF"

    property bool txtSmooth: true
    property color backgroundColor: "ivory"
    property color currentItemColor: "#FFF8C6"
    property color pressColor: "#FDE688"
    property int listFontSize : 32
    property string activePos: "http://finance.google.com/finance/feeds/default/portfolios/1/positions"
    property int selectedIdx: 0

    signal close
    signal update

    ListView {
        id: pfoView
        anchors.fill: parent
        model: pfoModel
        delegate: pfoDelegate
        focus: true
        snapMode: ListView.SnapToItem
    }

    Component {
        id: pfoDelegate

        Item {
            id: pfoDelegateItem
            width: pfoView.width
            height: 70

            Rectangle {
                id: background
                x: 5; y: 2; width: parent.width - x*2; height: parent.height - y*2
                color: container.backgroundColor
                border.color: "#3577B9"
                radius: 5
            }

            Text {
                id: nameBox
                anchors { left: background.left; leftMargin: 10; }

                smooth: txtSmooth
                font.bold: true
                font.pixelSize: listFontSize
                //verticalAlignment: Text.AlignVCenter
                text: name
            }

            MouseArea {
                id: mouseArea
                anchors.fill: background
                onClicked: {
                    activePos = feedLink;
                    console.log(activePos);
                    selectedIdx = index;
                    pfoDelegateItem.ListView.view.currentIndex = index;

                    container.update();
                }
            }

            // There is priority
            states: [
                State {
                    name: "Pressed"
                    when: mouseArea.pressed
                    PropertyChanges { target: background; color: container.pressColor }
                },
                State {
                    name: "highlightCurrentItem"
                    when: selectedIdx == index
                    PropertyChanges { target: background; color: container.currentItemColor }
                }
            ]
        }
    }
    BackButton {
        id: backButton
        anchors { bottom: container.bottom; left: container.left; leftMargin: 20; bottomMargin: 20; }
        focus: true
        width: 65
        height: 65
        onClicked: { container.close(); }
    }
}
