import QtQuick 1.0

import "js/script.js" as Script
import "js/storage.js" as Storage

Rectangle {
    id: mainWindow
    //property bool showWaitIndicator: waitState.state != "hidden"
    width: 640
    height: 480
    color: "#B0D8FF"

    property int startIndicator: 0
    property alias activePos: pfoMenu.activePos
    property alias activePfoIdx: pfoMenu.selectedIdx

    //property bool isLandscape: ( width > height )

    // Yahoo Finance model, no description!!
    XmlListModel {
        id: rssModel

        property string feedUrl: ""
        property bool loading: status == XmlListModel.Loading

        //source: "http://finance.yahoo.com/rss/headline?s=brcm" //feedUrl
        //source: "http://www.google.com/finance/company_news?q=NASDAQ:BRCM&output=rss"
        source: newsView.activeFeedUrl
        query: "/rss/channel/item"

        XmlRole { name: "title"; query: "title/string()" }
        XmlRole { name: "link"; query: "link/string()" }
        XmlRole { name: "desc"; query: "description/string()" }
        XmlRole { name: "date"; query: "pubDate/string()"; }//isKey: true }

        onStatusChanged: {
            if (status == XmlListModel.Ready) {
                console.log("FeedViewModel Status: ready")
            } else if (status == XmlListModel.Error) {
                console.log("FeedViewModel Status: error")
            } else if (status == XmlListModel.Loading) {
                console.log("FeedViewModel Status: loading")
            }
        }
    }

    ListModel {
         id: pfoModel
    }

    ListModel {
         id: posModel
    }

    Component.onCompleted: {
        Script.setComponents(pfoModel, posModel, waitState, errorState);
        Storage.getKeyValue("username", setLoginCredentials);
        Storage.getKeyValue("password", setLoginCredentials);
        Storage.getKeyValue("timer", setParams);
        Storage.getKeyValue("pfoStats", setParams);
        Storage.getKeyValue("activePos", setParams);
        Storage.getKeyValue("pfoActiveIdx", setParams);
    }


    function setLoginCredentials(key, data) {
        if(key=="username") {
            settingMenu.username = data;
        } else {
            settingMenu.password = data;
        }
        // Auto login
        if(settingMenu.username.length>0 &&
                settingMenu.password.length>0) {
            mainWindow.state = "inLogin";
        } else {
            startIndicator++;
            if(startIndicator==2) {
                console.log("Try to show login dialog");
                mainWindow.state = "inSettingView";
            }
        }
    }

    function setParams (key, data) {
        if(key=="timer") {
            if (data == "")   { settingMenu.timer = 10; }
            else              { settingMenu.timer = data; }
        }
        else if (key=="pfoStats") {
            if (data != "")   { settingMenu.usePortfolioView = data; }
        }
        else if (key=="activePos") {
            if (data != "") { pfoMenu.activePos = data; }
        }
        else if (key=="pfoActiveIdx") {
            if (data != "") { pfoMenu.selectedIdx = data; }
        }
    }

    // Header: Minimize/Notification/Close
    TitleBar {
        id: header
        anchors { top: parent.top; left: parent.left; }
        width: parent.width
        //showBusy: mainWindow.showWaitIndicator
        text: "stockona"
        z: 1

        onCallback: { mainWindow.state = "inPfoView"; }
    }

    NewsView {
        id: newsView
        //anchors.fill: parent
        anchors { top: header.bottom; bottom: parent.bottom; left: parent.left; right: parent.right; }
        visible: false

        onInMainView: { mainWindow.state = 'inStatsView' }
    }

    PosListView {
        id: mainView
        visible: false
        anchors { top: header.bottom; bottom: parent.bottom; left: parent.left; right: parent.right; }
        //anchors.fill: parent
        usePortfolioView: settingMenu.usePortfolioView
        //clip: true
        //contentHeight: parent.height - header.height

        onInNewsView:  { mainWindow.state = 'inNewsView' }
        onInStatsView: { mainWindow.state = 'inStatsView' }
        onInMainView:  { mainWindow.state = 'inMainView' }
    }

    PfoListView {
        id: pfoMenu
        visible: false
        //anchors.fill: parent
        anchors { top: header.bottom; bottom: parent.bottom; left: parent.left; right: parent.right; }

        onUpdate: {
            Storage.getKeyValue("activePos", loginUpdate);
            Storage.getKeyValue("pfoActiveIdx", loginUpdate);
            mainWindow.state = "inLoadPortfolio";
        }
        onClose: { mainWindow.state = "inMainView"; }
    }

    SettingMenu {
        id: settingMenu
        state: "hidden"
        //visible: false
        //anchors { top: header.bottom; bottom: parent.bottom; left: parent.left; right: parent.right; }

        onCallPfo: { mainWindow.state = "inPfoView"; }
        onSignin: {
            //Storage.getKeyValue("username", loginUpdate);
            //Storage.getKeyValue("password", loginUpdate);
            mainWindow.state = "inLogin";
        }
        onSignout: {
            Storage.setKeyValue("username", "");
            Storage.setKeyValue("password", "");
            mainWindow.state = "inLogin";
        }
        onClose: {
            // Call loginUpdate function
            //Storage.getKeyValue("username", loginUpdate);
            //Storage.getKeyValue("password", loginUpdate);
            Storage.getKeyValue("timer", loginUpdate);
            Storage.getKeyValue("pfoStats", loginUpdate);
            mainWindow.state = "inMainView";
        }
    }

    function loginUpdate(key, data) {
//        var loginChange = 0;

        if (key=="username" && (data != settingMenu.username)) {
            Storage.setKeyValue(key, settingMenu.username);
//            loginChange = 1;
        }

        if (key=="password" && (data != settingMenu.password)) {
            Storage.setKeyValue(key, settingMenu.password);
//            loginChange = 1;
        }

        // Robustness, minimum timer == 5
        if (key=="timer" && (data != settingMenu.timer)) {
            if (settingMenu.timer=="0") {
                Storage.setKeyValue(key, "5");
                settingMenu.timer="5";
            }
            else { Storage.setKeyValue(key, settingMenu.timer); }
        }

        if (key=="pfoStats" && (data != settingMenu.usePortfolioView)) {
            Storage.setKeyValue(key, settingMenu.usePortfolioView);
        }

        if (key=="activePos" && (data != pfoMenu.activePos)) {
            Storage.setKeyValue(key, pfoMenu.activePos);
        }

        if (key=="pfoActiveIdx" && (data != pfoMenu.selectedIdx)) {
            Storage.setKeyValue(key, pfoMenu.selectedIdx);
        }
    }

    Row {
        anchors { right: parent.right; bottom: parent.bottom; margins: 20 }
        spacing: 10

        TextButton {
            id: menuButton
            text: "Menu"
            onClicked: {
                mainWindow.state = "inSettingView";
            }
        }

        TextButton {
            id: funcButton
            text: "View"
            onClicked: {
               mainView.usePortfolioView =! mainView.usePortfolioView;
            }
        }

        TextButton {
            id: refreshButton
            text: "Refresh"
            onClicked: {
                Script.loadOnePosition(activePos);
                mainWindow.state = "inMainView";
            }
        }
    }

    BusyDialog {
        id: msgDialog
        anchors.centerIn: parent
        busyIndicatorOn: true
        opacity: 0

        MouseArea {
            id: msgMouseArea
            anchors.fill: parent
            onClicked: { waitState.state = "hidden"; }
        }
    }

    Item {
        id: waitState

        states: [
            State {
                name: "hidden"
            },
            State {
                name: "shown"
//                PropertyChanges{ target: mainWindow; showWaitIndicator: true }
            },
            // Control by javascript core
            State {
                name: "portfolio"
//                PropertyChanges{ target: mainWindow; showWaitIndicator: true }
                StateChangeScript {
                    name: "gotoPorfolio"
                    script: { fsmTimer.restart(); }
                }
            }
        ]
    }

    // Error dialog
    BusyDialog {
        id: errorDialog
        anchors.centerIn: parent
        busyIndicatorOn: false
        opacity: 0
        message: errorState.reason

        MouseArea {
            id: errorMouseArea
            anchors.fill: parent
            onClicked: {
                errorState.state = "hidden";
            }
        }
    }

    // Error state is reset whenever not in mainView
    Timer {
        id: errorTimer
        interval: 3000
        repeat: false
        onTriggered: {
            errorState.state = "hidden"
        }
    }

    Item {
        id: errorState

        property string reason: ""

        states: [
            State {
                name: "hidden"
                PropertyChanges { target: errorDialog; opacity: 0 }
            },
            State {
                name: "shown"
                PropertyChanges { target: errorDialog; opacity: 1 }
//                StateChangeScript {
//                    name: "startErrorTimer"
//                    script: { errorTimer.restart(); }
//                }
            }
        ]
    }

    // Timer to control update interval
    Timer {
        id: updateTimer
        interval: settingMenu.timer*1000
        repeat: true
        onTriggered: {
            //console.log("Timer="+settingMenu.timer+"s");
            Script.loadOnePosition(activePos);
        }
    }

    // Use a timer to delay events to avoid race conditions
    Timer {
        id: fsmTimer
        interval: 800
        repeat: false
        onTriggered: {
            //console.log("Timer="+fsmTimer.interval+"s");
            // Stop if in setting menu
            if (mainWindow.state!="inSettingView") { mainWindow.state="inLoadPortfolio"; }
        }
    }

    Timer {
        id: fsmTimer2
        interval: 500
        repeat: false
        onTriggered: {
            //console.log("fsmTimer2");
            mainWindow.state="inMainView";
        }
    }

    // FSM
    states: [
        State {
            name: "inLogin";

            PropertyChanges { target: msgDialog; message: "Logging in ..."; opacity: 1; }

            StateChangeScript {
                name: "loginStep"
                script: {
                    console.log("State.login");
                    Script.login(settingMenu.username, settingMenu.password);
                }
            }
        },

        State {
            name: "inLoadPortfolio";

            PropertyChanges { target: msgDialog; message: "Loading portfolio ..."; opacity: 1 }

            StateChangeScript {
                name: "PortfolioStep"
                script: {
                    console.log("State.loadPortfolio");
                    // clear posModel here
                    Script.cleanModel(posModel);
                    Script.loadAllPortfolios();
                    Script.loadOnePosition(activePos);

                    // fsmTimer2 only works for the first time?
                    fsmTimer2 .restart();
                }
            }
        },	
        State {
            name: "inMainView";

            PropertyChanges { target: mainView; visible: true }
            PropertyChanges { target: errorState; state: "hidden" }

            PropertyChanges { target: menuButton; visible: true     }
            PropertyChanges { target: funcButton; visible: true     }
            PropertyChanges { target: refreshButton; visible: true  }

            StateChangeScript {
                name: "mainView"
                script: {
                    console.log("State.main");
//                    Script.loadOnePosition(activePos);

                    updateTimer.restart();
                }
            }
        },

        State {
            name: "inPfoView";

            PropertyChanges { target: pfoMenu; visible: true }

            PropertyChanges { target: menuButton; visible: false     }
            PropertyChanges { target: funcButton; visible: false     }
            PropertyChanges { target: refreshButton; visible: false  }
            PropertyChanges { target: errorState; state: "hidden" }

            StateChangeScript {
                name: "pfoView"
                script: {
                    console.log("State.pfoView");
                    updateTimer.stop();

                    // Re-load portfolio if loading failed earlier.
                    if (pfoModel.count==0) { console.log("Reload portfolio"); Script.loadAllPortfolios(); }
                }
            }
        },

        State {
            name: "inSettingView";

            PropertyChanges { target: settingMenu; visible: true     }
            PropertyChanges { target: settingMenu; state: "shown"     }

            PropertyChanges { target: errorState; state: "hidden" }

            PropertyChanges { target: menuButton; visible: false     }
            PropertyChanges { target: funcButton; visible: false     }
            PropertyChanges { target: refreshButton; visible: false  }

            StateChangeScript {
                name: "settingView"
                script: {
                    console.log("State.settingView");

                    fsmTimer.stop();
                    fsmTimer2.stop();
                    updateTimer.stop();
                }
            }
        },

        State {
            name: "inNewsView";

            PropertyChanges { target: newsView; visible: true }
            PropertyChanges { target: menuButton; visible: false     }
            PropertyChanges { target: funcButton; visible: false     }
            PropertyChanges { target: refreshButton; visible: false  }
            PropertyChanges { target: errorState; state: "hidden" }

            StateChangeScript {
                name: "newsView"
                script: {
                    console.log("State.newsView");
                    updateTimer.stop();
                }
            }
        },

        State {
            name: "inStatsView";

            PropertyChanges { target: mainView; visible: true }

            PropertyChanges { target: menuButton; visible: false     }
            PropertyChanges { target: funcButton; visible: false     }
            PropertyChanges { target: refreshButton; visible: false  }
            PropertyChanges { target: errorState; state: "hidden" }

            StateChangeScript { name: "statsView"; script: { console.log("State.statsView"); } }
        }
    ]
}
