import QtQuick 1.0

Rectangle {
    id: container
    width: parent.width
    height: 50
    color: "#E4F5FF"
    radius: 5

    property real textSize: 12
    property alias text: label.text

    property color textColor: "#396AB3"
    property color pressedColor: "#68C8FF"

    signal clicked

    Text {
        id: label;
        width: parent.width
        height: parent.height
        color: textColor
        font.pixelSize: textSize
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    MouseArea {
        id: mouseArea
        anchors.fill: parent
        onClicked: {
            container.clicked();
        }
    }

    states: State {
        name: "pressed"
        when: mouseArea.pressed
        PropertyChanges { target: container; color: container.pressedColor }
    }

}
