/*
    Copyright 2011 - Tommi Laukkanen (www.substanceofcode.com)

    This file is part of NewsFlow.

    NewsFlow is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    NewsFlow is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with NewsFlow. If not, see <http://www.gnu.org/licenses/>.
*/

var sid = "";
var sidToken = "";
var debug = 0;

// UI components
var waiting;
var error;

var model;
var pModel;

var continuation = "";
var actionID = "";
var actionFeedUrl = ""
var accessToken = "";
var action = "";
var tags = "";

var itemsURL = "";

function setComponents(mod, pos, wait, err) {
    model   = mod;
    pModel  = pos;
    waiting = wait;
    error   = err;
}

// This will parse a delimited string into an array of
// arrays. The default delimiter is the comma, but this
// can be overriden in the second argument.
function CSVToArray( strData, strDelimiter ){
// Check to see if the delimiter is defined. If not,
// then default to comma.
strDelimiter = (strDelimiter || ",");

// Create a regular expression to parse the CSV values.
var objPattern = new RegExp(
(
// Delimiters.
"(\\" + strDelimiter + "|\\r?\\n|\\r|^)" +

// Quoted fields.
"(?:\"([^\"]*(?:\"\"[^\"]*)*)\"|" +

// Standard fields.
"([^\"\\" + strDelimiter + "\\r\\n]*))"
),
"gi"
);


// Create an array to hold our data. Give the array
// a default empty first row.
var arrData = [[]];

// Create an array to hold our individual pattern
// matching groups.
var arrMatches = null;


// Keep looping over the regular expression matches
// until we can no longer find a match.
while (arrMatches = objPattern.exec( strData )){

// Get the delimiter that was found.
var strMatchedDelimiter = arrMatches[ 1 ];

// Check to see if the given delimiter has a length
// (is not the start of string) and if it matches
// field delimiter. If id does not, then we know
// that this delimiter is a row delimiter.
if (
strMatchedDelimiter.length &&
(strMatchedDelimiter != strDelimiter)
){

// Since we have reached a new row of data,
// add an empty row to our data array.
arrData.push( [] );

}


// Now that we have our delimiter out of the way,
// let's check to see which kind of value we
// captured (quoted or unquoted).
if (arrMatches[ 2 ]){

// We found a quoted value. When we capture
// this value, unescape any double quotes.
var strMatchedValue = arrMatches[ 2 ].replace(
new RegExp( "\"\"", "g" ),
"\""
);

} else {

// We found a non-quoted value.
var strMatchedValue = arrMatches[ 3 ];

}


// Now that we have our value string, let's add
// it to the data array.
arrData[ arrData.length - 1 ].push( strMatchedValue );
}

// Return the parsed data.
return( arrData );
}

function doWebRequest(method, url, params, callback, show) {
    var doc = new XMLHttpRequest();
    //console.log(method + " " + url);

    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.HEADERS_RECEIVED) {
            var status = doc.status;
            if(status!=200) {
                showError("API returned " + status + " " + doc.statusText, show);
            }
        } else if (doc.readyState == XMLHttpRequest.DONE) {
            var data;
            var contentType = doc.getResponseHeader("Content-Type");
            if (params>=1) {
                data = doc.responseText;
            }
            else {
                data = doc.responseXML.documentElement;
            }
//            var dbg = doc.responseText;
//            console.log(dbg);
            callback(data);
        }
    }

    doc.open(method, url);
    if(sid.length>0 && params<2) {
        // Google Finance ignore SID/LSID
        //console.log("Authorization GoogleLogin auth=" + sid);
        doc.setRequestHeader("Authorization", "GoogleLogin auth=" + sid);
        // Specifying a version
        doc.setRequestHeader("GData-Version", "2");
        //doc.setRequestHeader("Cookie", "SID=" + sidToken);
    }

    if(params==1) {
        //console.log("Sending: " + params);
        doc.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        doc.send();
    } else {
        doc.send();
    }
}

function doWebRequestIdx(method, url, params, callback, idx, show) {
    var doc = new XMLHttpRequest();
    //console.log(method + " " + url);

    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.HEADERS_RECEIVED) {
            var status = doc.status;
            if(status!=200) {
                showError("Google API returned " + status + " " + doc.statusText, show);
            }
        } else if (doc.readyState == XMLHttpRequest.DONE) {
            var data;
            var contentType = doc.getResponseHeader("Content-Type");
            if (params==1) {
                data = doc.responseText;
            }
            else {
                data = doc.responseXML.documentElement;
            }
//            var dbg = doc.responseText;
//            console.log(dbg);
            callback(data, idx);
        }
    }

    doc.open(method, url);
    if(sid.length>0) {
        // Google Finance ignore SID/LSID
        //console.log("Authorization GoogleLogin auth=" + sid);
        doc.setRequestHeader("Authorization", "GoogleLogin auth=" + sid);
        // Specifying a version
        doc.setRequestHeader("GData-Version", "2");
        //doc.setRequestHeader("Cookie", "SID=" + sidToken);
    }

    if(params==1) {
        //console.log("Sending: " + params);
        doc.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        doc.send();
    } else {
        doc.send();
    }
}

/** Parse parameter from given URL */
function parseAuth(data, parameterName) {
    var parameterIndex = data.indexOf(parameterName + "=");
    if(parameterIndex<0) {
        // We didn't find parameter
        console.log("Didn't find Auth");
        //addError("Didn't find Auth");
        return "";
    }
    var equalIndex = data.indexOf("=", parameterIndex);
    if(equalIndex<0) {
        return "";
    }

    var lineBreakIndex = data.indexOf("\n", equalIndex+1)

    var value = "";
    value = data.substring(equalIndex+1, lineBreakIndex);
    return value;
}

function parseToken(data) {
    sid = parseAuth(data, "Auth");
    //console.log("Auth=" + sid);
    //sidToken = parseAuth(data, "SID");
    //console.log("SID=" + sidToken);

    if(sid.length>0) {
        //waiting.state = "hidden";
        waiting.state = "portfolio";
    } else {
        //addError("Couldn't parse SID");
        addError("Login failed.\nCheck username/password");
        waiting.state = "hidden";
    }
}

function login(email, password) {
    try {
        waiting.state = "login";
        var url = "https://www.google.com/accounts/ClientLogin?Email=" + encodeURIComponent(email) + "&Passwd=" + encodeURIComponent(password) + "&service=finance" + "&source=" + encodeURIComponent("stockona");
        doWebRequest("POST", url, 1, parseToken, 0);
    }catch(err) {
        showError("Error while logging in: " + err, 1);
    }
}

function showError(msg, dbg) {
    console.log(msg);
    waiting.state = "hidden";

    if (dbg>0) {
        error.reason = msg;
        error.state = "shown";
    }
}

function addError(msg) {
    console.log(msg);
    error.reason = msg;
    error.state = "shown";
}

function loadAllPortfolios() {
    itemsURL = "http://finance.google.com/finance/feeds/default/portfolios";
    console.log(itemsURL);
    loadPortfolio();
}

function loadOnePosition(posFeedLink) {
    // Pull both return and transactions info
    itemsURL = posFeedLink+"?returns=true&transactions=true";
    //itemsURL = "http://finance.google.com/finance/feeds/default/portfolios/2/positions?returns=true&transactions=true";
    console.log(itemsURL);
    loadPosition();
}

function loadOneQuote(symObj, idx) {
    itemsURL = "http://www.google.com/finance/info?client=ig&infotype=infoquoteall&q="+symObj.symName;
    //console.log(itemsURL);
    loadQuote(symObj, idx);
}

function loadAllYahooQuote(quoteList) {
    itemsURL =   "http://download.finance.yahoo.com/d/quotes.csv?s="+ quoteList + "&f=b2b3";
    //console.log(itemsURL);
    loadYahooQuote();
}

function loadOnePortfolio(PortfolioName) {
    itemsURL = "http://finance.google.com/finance/feeds/default/portfolios/"+PortfolioName;
    loadPortfolio();
}

function loadPortfolio() {
    try {
        model.clear();
        //pModel.clear();
        // Have to set to "portfolio", o.w. stategroup error message
        waiting.state = "portfolio";
        doWebRequest("GET", itemsURL, 0, parsePortfolio, 1);
    } catch(err) {
        showError("Error while loading portfolio: " + err, 1);
    }
}

function loadPosition() {
    try {
        // Have to set to "position", o.w. stategroup error message
        waiting.state = "position";
        doWebRequest("GET", itemsURL, 0, parsePosition, 2);
    } catch(err) {
        showError("Error while loading position: " + err, 1);
    }
}

function loadQuote(symObj, idx) {
    var rtnYTDTrunc = sprintf("%.2f", 100*symObj.symRtnYTD);

    if (idx >= pModel.count) {
        pModel.append({
                     "idx":            idx,
                     "id":             symObj.symId,
                     "gainPercent":    "0",
                     "gainPercentFull":symObj.symGainPercent,
                     "rtnYTD":         rtnYTDTrunc,
                     "share":          symObj.symShare,
                     "shareCost":      symObj.shareCost,
                     "shareValue":     symObj.shareValue,

                     "exchange":       "-",
                     "fullName":       "-",
                     "name":           "Loading",

                     "quotePrice":     "-",

                     "quoteChgColor":  "green",
                     "quoteChg":       "-",
                     "quoteChgPtg":    "-",
                     "quoteVol":       "-",
                     "quoteAvgVol":    "-",
                     "quoteMktCap":    "-",

                     "quoteDayHi":     "-",
                     "quoteDayLo":     "-",
                     "quote52wHi":     "-",
                     "quote52wLo":     "-",

                     "quoteEps":       "-",
                     "quoteBeta":      "-",
                     "quotePe":        "-",
                     "quoteType":      "-",

                     "quoteAsk":       "-",
                     "quoteBid":       "-"

        });
    }
    else {
        pModel.set(idx, {
            "share":          symObj.symShare,
            "gainPercentFull":symObj.symGainPercent,
            "rtnYTD":         rtnYTDTrunc, //symObj.symRtnYTD
            "shareCost":      symObj.shareCost,
            "shareValue":     symObj.shareValue

        });
    }

    try {
        waiting.state = "shown";
        doWebRequestIdx("GET", itemsURL, 1, parseJSON, idx, 3);
    } catch(err) {
        showError("Error while loading g_quote: " + err, 1);
    }
}

function loadYahooQuote() {
    try {
        waiting.state = "shown";
        doWebRequest("GET", itemsURL, 2, parseCSV, 3);
    } catch(err) {
        showError("Error while loading y_quote: " + err, 1);
    }
}

function showData(data) {
    console.log("DONE: " + data);
}

function getNode(node, name) {
    for(var i=0; i<node.childNodes.length; i++) {
        var nodeName = node.childNodes[i].nodeName;
        if(nodeName==name) {
            return node.childNodes[i].firstChild;
        }
    }

    return node;
}

function parsePortfolio(data) {
    //try {
        //console.log("DATA: " + data);

        // 2) XML DOM
        // <openSearch::totalResults>
        var pfoLength = data.childNodes[8].firstChild.nodeValue;
        //console.log("pfo.length="+pfoLength);

        // <entry>
        for (var i=0; i<pfoLength; i++) {
            var pfoEtag        = data.childNodes[11+i].attributes[0].nodeValue;
            var pfoId          = data.childNodes[11+i].childNodes[0].firstChild.nodeValue;      // 1,2,3...

            var pfoName        = data.childNodes[11+i].childNodes[4].firstChild.nodeValue;      // Title
            var pfoFeedLink    = data.childNodes[11+i].childNodes[7].attributes[0].nodeValue;   // Link of position
            var currency       = data.childNodes[11+i].childNodes[8].attributes[0].nodeValue;
            var pfoGainPercent = data.childNodes[11+i].childNodes[8].attributes[1].nodeValue;
            var pfoRtnYTD      = data.childNodes[11+i].childNodes[8].attributes[9].nodeValue;

            // Push to pfoModel
//            if (i<=model.count) {
//                model.set(i, {
//                             "idx": i,
//                             "name": pfoName,
//                             "etag": pfoEtag,
//                             "id": pfoId,
//                             "feedLink": pfoFeedLink,
//                             "currency": currency,
//                             "gainPercent": pfoGainPercent,
//                             "rtnYTD": pfoRtnYTD

//                });
//            }
//            else {
                model.append({
                             "idx": i,
                             "name": pfoName,
                             "etag": pfoEtag,
                             "id": pfoId,
                             "feedLink": pfoFeedLink,
                             "currency": currency,
                             "gainPercent": pfoGainPercent,
                             "rtnYTD": pfoRtnYTD

                });
//            }

            /*
            console.log("<Portfolio.entry>");
            console.log("pfo.name"+pfoName);
            console.log("pfo.etag="+pfoEtag);
            console.log("pfo.Id="+pfoId);
            console.log("pfo.feedLink="+pfoFeedLink);
            console.log("currency="+currency);
            console.log("pfo.gainPercent="+pfoGainPercent);
            console.log("pfo.rtnYTD="+pfoRtnYTD);
            */
        }

    //}catch(err) {
    //    addError("Error: " + err);
    //}
//    waiting.state = "hidden";
    waiting.state = "position";
}

function parsePosition(data) {
    //try {
        // 2) XML DOM
        var posLength = data.childNodes[7].firstChild.nodeValue;
        //console.log("pos.length="+posLength);
        var quoteList = "";

        // <entry>
        /*
        Index:5
        <gd:feedLink href='http://finance.google.com/finance/feeds/portfolios/2/positions/NYSE:VNQ/transactions'>
                <feed gd:etag='W/&quot;AkcDRX47eCp7ImA9WhZVEU4.&quot;'>
                        <id>http://finance.google.com/finance/feeds/portfolios/2/positions/NYSE:VNQ/transactions</id>
                        <updated>2011-05-23T08:07:54.000Z</updated>
                        <category scheme='http://schemas.google.com/g/2005#kind' term='http://schemas.google.com/finance/2007#transaction'/>
                        <title>Vanguard REIT ETF</title>
                        <link rel='alternate' type='text/html' href='https://finance.google.com/finance/portfolio?action=viewt&amp;pid=0'/>
                        <link rel='http://schemas.google.com/g/2005#feed' type='application/atom+xml' href='http://finance.google.com/finance/feeds/default/portfolios/2/positions'/>
                        <openSearch:totalResults>1</openSearch:totalResults>
                        <openSearch:itemsPerPage>1</openSearch:itemsPerPage>
                        <entry gd:etag='W/&quot;AkcDRX47eCp7ImA9WhZVEU4.&quot;'>
                                <id>http://finance.google.com/finance/feeds/portfolios/2/positions/NYSE:VNQ/transactions/2</id>
                                <updated>2011-05-23T08:07:54.000Z</updated>
                                <category scheme='http://schemas.google.com/g/2005#kind' term='http://schemas.google.com/finance/2007#transaction'/>
                                <title>2</title>
                                <link rel='self' type='application/atom+xml' href='http://finance.google.com/finance/feeds/default/portfolios/2/positions/2'/>
                                <gf:transactionData shares='0.0' type='Buy'>
                                    <gf:commission>
                                            <gd:money amount='0.0' currencyCode='USD'/>
                                    </gf:commission>
                                    <gf:price>
                                            <gd:money amount='0.0' currencyCode='USD'/>
                                    </gf:price>
                                </gf:transactionData>
                        </entry>
                </feed>
        </gd:feedLink>

        <gf:positionData gainPercentage='4.31125' return1w='-0.08770799785'
            return1y='1.014937759' return3m='0.3299945223' return3y='4.31125'
            return4w='-0.01615050651' return5y='4.31125' returnOverall='4.31125'
            returnYTD='1.00330033' shares='1000.0'>
          <gf:costBasis>
            <gd:money amount='32000.0' currencyCode='USD'/>
          </gf:costBasis>
          <gf:daysGain>
            <gd:money amount='16200.0' currencyCode='USD'/>
          </gf:daysGain>
          <gf:gain>
            <gd:money amount='137960.0' currencyCode='USD'/>
          </gf:gain>
          <gf:marketValue>
            <gd:money amount='169960.0' currencyCode='USD'/>
          </gf:marketValue>
        </gf:positionData>
        */
        for (var i=0; i<posLength; i++) {
            // Transaction data
            var txLength =data.childNodes[10+i].childNodes[5].firstChild.childNodes[6].firstChild.nodeValue;

            // Catch-ya: when there is tx record available, the first gf transactiondata node becomes the date
            for (var j=0; j<txLength; j=j+1) {
                // Check attribute number
                var txTxDataAttLength = data.childNodes[10+i].childNodes[5].firstChild.childNodes[8+j].childNodes[5].attributes.length;
                var txTxDataOffset = (txTxDataAttLength>=3);

                var txObj = {
                    //"txTrue"        : txTxDataOffset, // 1: Has valid tx data
                    "txDate"        : data.childNodes[10+i].childNodes[5].firstChild.childNodes[8+j].childNodes[5].attributes[0].nodeValue,
                    "txShare"       : data.childNodes[10+i].childNodes[5].firstChild.childNodes[8+j].childNodes[5].attributes[0+txTxDataOffset].nodeValue,
                    "txType"        : data.childNodes[10+i].childNodes[5].firstChild.childNodes[8+j].childNodes[5].attributes[1+txTxDataOffset].nodeValue,
                    // per share price
                    "txPrice"       : data.childNodes[10+i].childNodes[5].firstChild.childNodes[8+j].childNodes[5].childNodes[1].firstChild.attributes[0].nodeValue,
                    "txPriceUnit"   : data.childNodes[10+i].childNodes[5].firstChild.childNodes[8+j].childNodes[5].childNodes[1].firstChild.attributes[1].nodeValue,
                    // commission
                    "txCom"         : data.childNodes[10+i].childNodes[5].firstChild.childNodes[8+j].childNodes[5].childNodes[0].firstChild.attributes[0].nodeValue,
                    "txComUnit"     : data.childNodes[10+i].childNodes[5].firstChild.childNodes[8+j].childNodes[5].childNodes[0].firstChild.attributes[1].nodeValue
            };

//                console.log("####="+symObj.symName);
//                console.log("txLength "     +   txLength   );
//                console.log("txAttLength "  +   txTxDataAttLength);
//                console.log(" txShare "     +  txObj.txShare    );
//                console.log(" txType "      +  txObj.txType     );
//                console.log(" txPrice "     +  txObj.txPrice    );
//                console.log(" txPriceUnit " +  txObj.txPriceUnit);
//                console.log(" txCom "       +  txObj.txCom      );
//                console.log(" txComUnit "   +  txObj.txComUnit  );
            }

            var symObj = {
                "symId"          : data.childNodes[10+i].childNodes[0].firstChild.nodeValue,
                "symGainPercent" : data.childNodes[10+i].childNodes[6].attributes[0].nodeValue,
                "symRtnYTD"      : data.childNodes[10+i].childNodes[6].attributes[8].nodeValue,
                "symShare"       : data.childNodes[10+i].childNodes[6].attributes[9].nodeValue,
                "symName"        : data.childNodes[10+i].childNodes[7].attributes[2].nodeValue,

                "shareCost"  : "0",
                "shareValue" : "0",
                //"shareGain"  : "0"

                // Don't parse for now...
                //"symEtag"        : data.childNodes[10+i].attributes[0].nodeValue,
                //"symFeedLink"    : data.childNodes[10+i].childNodes[5].attributes[0].nodeValue,   // transaction link

                //"symExg"         : data.childNodes[10+i].childNodes[7].attributes[0].nodeValue,
                //"symFullName"    : data.childNodes[10+i].childNodes[7].attributes[1].nodeValue,
            };

            // costBasis, gain, mktValue. Only those who have TX records are available
            if (data.childNodes[10+i].childNodes[6].childNodes.length==4) {
                symObj.shareCost   = data.childNodes[10+i].childNodes[6].childNodes[0].firstChild.attributes[0].nodeValue;
                //symObj.shareGain   = data.childNodes[10+i].childNodes[6].childNodes[2].firstChild.attributes[0].nodeValue;
                symObj.shareValue  = data.childNodes[10+i].childNodes[6].childNodes[3].firstChild.attributes[0].nodeValue;
                //symObj.symCostUnit = data.childNodes[10+i].childNodes[6].childNodes[0].firstChild.attributes[1].nodeValue;
            }

            //console.log(symObj.symName + " cost=" + symObj.shareCost + " value=" + symObj.shareValue + " gain=" + symObj.shareGain);

            // JSON Parsing, parsed data stored in global jsonObj.
            // Push needs to be done in parseJSON to keep the program synchronous.
            loadOneQuote(symObj, i);
            quoteList = quoteList + "+" + symObj.symName;

            /*
            console.log("<position.entry>");
            //console.log("pos.etag="+symObj.symEtag);
            console.log("pos.id="+symObj.symId);
            console.log("pos.feedLink="+symObj.symFeedLink);
            console.log("pos.gainPercent="+symObj.symGainPercent);
            console.log("pos.rtnYTD="+symObj.symRtnYTD);
            console.log("pos.share="+symObj.symShare);
            console.log("pos.exchange="+symObj.symExg);
            console.log("pos.fullName="+symObj.symFullName);
            console.log("pos.name="+symObj.symName);
            //*/
        }

        // Take out leading +
        quoteList = quoteList.replace(/^\+/, "");
        loadAllYahooQuote(quoteList);

    //}catch(err) {
    //    addError("Error: " + err);
    //}
    waiting.state = "hidden";
}

// There is a Yahoo real-time feed!
function parseCSV(data) {
    /*
      Ask: b2
      Bid: b3
      Ask size: a5
      Bid size: b6
      After Hours Change (Real-time): c8 (broken?)
      d: dividend per share (inconsistent with GF)
      y: dividend yield (inconsistent with GF)
    */
    // Array[Row][Column]
    //console.log(data);
    var csvObj = CSVToArray(data);

    if (csvObj == "0") {
        waiting.state = "hidden";
        return;
    }
    else {
        for (var i=0; i<pModel.count; i=i+1) {
            //console.log(i+":(Ask,Bid) = "+csvObj[i][0] + "/" + csvObj[i][1])
            pModel.set(i, {
                       "quoteAsk": (csvObj[i][0]=="N/A") ? "-" : csvObj[i][0],
                       "quoteBid": (csvObj[i][1]=="N/A") ? "-" : csvObj[i][1]
        });
        }
    }
}

function parseJSON(data, idx) {
    // Remove comment // at the beginning
    //data = data.replace(/\/\//, "");
    data = removeComment(data);
    //console.log(data);

    // eval is unsafe, but JSON.parse is prone to fail
    var jsonObj = eval("(" + data + ")");
    //var jsonObj = JSON.parse(data);
    //console.log(jsonObj[0].l_cur);

    if (jsonObj==null || typeof(jsonObj)==undefined) {
        waiting.state = "hidden";
        return;
    }
    else {
        var quoteChgColor;
        var chgSymbol = jsonObj[0].c.match(/^\-/);
        if (chgSymbol != null) {
            quoteChgColor = "red";
        }
        else {
            quoteChgColor = "green";
        }

        // Compute share value and cost for now...
        var gainPtg = pModel.get(idx).gainPercentFull;
        // truncate precision (or error to be exact)
        var gainPtgTrunc = sprintf("%.2f", gainPtg*100);

        /*
        var share = pModel.get(idx).share;
        var shareValue = sprintf("%.4f", share*jsonObj[0].l);
        console.log(jsonObj[0].t+" "+share+" "+jsonObj[0].l);
        console.log(jsonObj[0].t+" "+shareValue+" "+share);

        // gainPtg can be positive or negative
        //var shareCost;
        if (gainPtg.match(/^\+/)=="+") {
            // Remove +
            gainPtg = gainPtg.replace(/^\+/, "");
            //shareCost = formatNumber(shareValue/(1+parseFloat(gainPtg)));
        }
        else {
            // Remove -
            gainPtg = gainPtg.replace(/^\-/, "");
            //shareCost = formatNumber(shareValue/(1-parseFloat(gainPtg)));
        }

        // Human readable data
        shareValue = formatNumber(share*jsonObj[0].l);
        */
    }

    // Check if entry already exists, if not append, if yes set.
    // Use set method to avoid flickering when updating content by timer

    if (idx<=pModel.count) {

        pModel.set(idx, {
                     "exchange":       (jsonObj[0].e   =="") ? "-" : jsonObj[0].e   ,    //symObj.symExg,
                     "fullName":       (jsonObj[0].name=="") ? "-" : jsonObj[0].name, //symObj.symFullName,
                     "name":           (jsonObj[0].t   =="") ? "-" : jsonObj[0].t   ,    //symObj.symName,
                     "gainPercent":    (gainPtgTrunc   =="") ? "-" : gainPtgTrunc   ,
                     "quotePrice":     (jsonObj[0].l   =="") ? "-" : jsonObj[0].l   ,
                     "quoteChgColor":  (quoteChgColor  =="") ? "-" : quoteChgColor  ,
                     "quoteChg":       (jsonObj[0].c   =="") ? "-" : jsonObj[0].c   ,
                     "quoteChgPtg":    (jsonObj[0].cp  =="") ? "-" : jsonObj[0].cp  ,
                     "quoteVol":       (jsonObj[0].vo  =="") ? "-" : jsonObj[0].vo  ,
                     "quoteAvgVol":    (jsonObj[0].avvo=="") ? "-" : jsonObj[0].avvo,
                     "quoteMktCap":    (jsonObj[0].mc  =="") ? "-" : jsonObj[0].mc  ,
                     "quoteDayHi":     (jsonObj[0].hi  =="") ? "-" : jsonObj[0].hi  ,
                     "quoteDayLo":     (jsonObj[0].lo  =="") ? "-" : jsonObj[0].lo  ,
                     "quote52wHi":     (jsonObj[0].hi52=="") ? "-" : jsonObj[0].hi52,
                     "quote52wLo":     (jsonObj[0].lo52=="") ? "-" : jsonObj[0].lo52,
                     "quoteEps":       (jsonObj[0].eps =="") ? "-" : jsonObj[0].eps ,
                     "quoteBeta":      (jsonObj[0].beta=="") ? "-" : jsonObj[0].beta,
                     "quotePe":        (jsonObj[0].pe  =="") ? "-" : jsonObj[0].pe  ,
                     "quoteType":      (jsonObj[0].type=="") ? "-" : jsonObj[0].type
        });
    }
    /*
    else {
        //pModel.insert(idx, {
        pModel.append({
                     "exchange":       jsonObj[0].e,    //symObj.symExg,
                     "fullName":       jsonObj[0].name, //symObj.symFullName,
                     "name":           jsonObj[0].t,    //symObj.symName,

                     "quotePrice":     jsonObj[0].l,

                     "quoteChgColor":  quoteChgColor,
                     "quoteChg":       jsonObj[0].c,
                     "quoteChgPtg":    jsonObj[0].cp,
                     "quoteVol":       jsonObj[0].vo,
                     "quoteAvgVol":    jsonObj[0].avvo,
                     "quoteMktCap":    jsonObj[0].mp,

                     "quoteDayHi":     jsonObj[0].hi,
                     "quoteDayLo":     jsonObj[0].lo,
                     "quote52wHi":     jsonObj[0].hi52,
                     "quote52wLo":     jsonObj[0].lo52,

                     "quoteEps":       jsonObj[0].eps,
                     "quoteBeta":      jsonObj[0].beta,
                     "quotePe":        jsonObj[0].pe,
                     "quoteType":      jsonObj[0].type
        });
    }
    */
    waiting.state = "hidden";
}

function cleanModel(model) {
    model.clear();
}

function getNodeValue(node, name) {
    var nodeValue = "";
    for(var i=0; i<node.childNodes.length; i++) {
        var nodeName = node.childNodes[i].nodeName;
        if(nodeName==name) {
            nodeValue = node.childNodes[i].firstChild.nodeValue;
        }
    }
    return nodeValue;
}

function formatNumber(data) {
    // > 1M: Display M
    // > 10k: Display K
    var tmp;
    if (Number(data)>1000000) {
        tmp = sprintf("%.2f", Number(data)/1000000);
        return tmp + "m";
    }
    else if (Number(data)>10000) {
        tmp = sprintf("%.2f", Number(data)/10000);
        return tmp + "k";
    }
    else {
        return sprintf("%.2f", Number(data));
    }
}

function removeLinks(original) {
    var txt = original;
    txt = txt.replace(/<a /g, "<span ");
    txt = txt.replace(/<\/a>/g, "</span>");
    return txt;
}

// function from http://forums.devshed.com/t39065/s84ded709f924610aa44fff827511aba3.html
// author appears to be Robert Pollard
function sprintf()
{
   if (!arguments || arguments.length < 1 || !RegExp)
   {
      return;
   }
   var str = arguments[0];
   var re = /([^%]*)%('.|0|\x20)?(-)?(\d+)?(\.\d+)?(%|b|c|d|u|f|o|s|x|X)(.*)/;
   var a = [];
   var b = [];
   var numSubstitutions = 0;
   var numMatches = 0;
   while (a = re.exec(str))
   {
      var leftpart = a[1], pPad = a[2], pJustify = a[3], pMinLength = a[4];
      var pPrecision = a[5], pType = a[6], rightPart = a[7];

      numMatches++;
      if (pType == '%')
      {
         subst = '%';
      }
      else
      {
         numSubstitutions++;
         if (numSubstitutions >= arguments.length)
         {
            alert('Error! Not enough function arguments (' + (arguments.length - 1)
               + ', excluding the string)\n'
               + 'for the number of substitution parameters in string ('
               + numSubstitutions + ' so far).');
         }
         var param = arguments[numSubstitutions];
         var pad = '';
                if (pPad && pPad.substr(0,1) == "'") pad = leftpart.substr(1,1);
           else if (pPad) pad = pPad;
         var justifyRight = true;
                if (pJustify && pJustify === "-") justifyRight = false;
         var minLength = -1;
                if (pMinLength) minLength = parseInt(pMinLength);
         var precision = -1;
                if (pPrecision && pType == 'f')
                   precision = parseInt(pPrecision.substring(1));
         var subst = param;
         switch (pType)
         {
         case 'b':
            subst = parseInt(param).toString(2);
            break;
         case 'c':
            subst = String.fromCharCode(parseInt(param));
            break;
         case 'd':
            subst = parseInt(param) ? parseInt(param) : 0;
            break;
         case 'u':
            subst = Math.abs(param);
            break;
         case 'f':
            subst = (precision > -1)
             ? Math.round(parseFloat(param) * Math.pow(10, precision))
              / Math.pow(10, precision)
             : parseFloat(param);
            break;
         case 'o':
            subst = parseInt(param).toString(8);
            break;
         case 's':
            subst = param;
            break;
         case 'x':
            subst = ('' + parseInt(param).toString(16)).toLowerCase();
            break;
         case 'X':
            subst = ('' + parseInt(param).toString(16)).toUpperCase();
            break;
         }
         var padLeft = minLength - subst.toString().length;
         if (padLeft > 0)
         {
            var arrTmp = new Array(padLeft+1);
            var padding = arrTmp.join(pad?pad:" ");
         }
         else
         {
            var padding = "";
         }
      }
      str = leftpart + padding + subst + rightPart;
   }
   return str;
}

function prettyDate(date){
    try {
        var diff = (((new Date()).getTime() - date.getTime()) / 1000);
        var day_diff = Math.floor(diff / 86400);

        if ( isNaN(day_diff) || day_diff >= 31 ) {
            //console.log("Days: " + day_diff);
            return "some time ago";
        } else if (day_diff < 0) {
            //console.log("day_diff: " + day_diff);
            return "just now";
        }

        return day_diff == 0 && (
                    diff < 60 && "just now" ||
                    diff < 120 && "1 minute ago" ||
                    diff < 3600 && Math.floor( diff / 60 ) + " min ago" ||
                    diff < 7200 && "1 hour ago" ||
                    diff < 86400 && Math.floor( diff / 3600 ) + " hours ago") ||
                day_diff == 1 && "Yesterday" ||
                day_diff < 7 && day_diff + " days ago" ||
                day_diff < 31 && Math.ceil( day_diff / 7 ) + " weeks ago";
        day_diff >= 31 && Math.ceil( day_diff / 30 ) + " months ago";
    } catch(err) {
        console.log("Error: " + err);
        return "some time ago";
    }
}

// 2011-01-24T18:48:00Z
function parseDate(stamp)
{
    try {
        //console.log("stamp: " + stamp);
        var parts = stamp.split("T");
        var day;
        var time;
        var hours;
        var minutes;
        var seconds = 0;
        var year;
        var month;

        var dates = parts[0].split("-");
        year = parseInt(dates[0]);
        month = parseInt(dates[1])-1;
        day = parseInt(dates[2]);

        var times = parts[1].split(":");
        hours = parseInt(times[0]);
        minutes = parseInt(times[1]);

        var dt = new Date();
        dt.setUTCDate(day);
        dt.setYear(year);
        dt.setUTCMonth(month);
        dt.setUTCHours(hours);
        dt.setUTCMinutes(minutes);
        dt.setUTCSeconds(seconds);

        //console.log("day: " + day + " year: " + year + " month " + month + " hour " + hours);

        return dt;
    } catch(err) {
        console.log("Error while parsing date: " + err);
        return new Date();
    }
}

function removeComment(data) {
    data = data.replace(/\/\//, "");
    return data;
}
