#!/usr/bin/env python
# coding=utf-8

from PyQt4 import *
from PyQt4.Qt import QVariant
from PyQt4.QtGui import *
from PyQt4.QtCore import *
import sys
import urllib, urllib2
import traceback
from Util import *
from StockMatchTableDelegate import *
import PyQt4.Qt

class GFMatcher:

    BUFFER_SIZE = 1024
    BASE_GFINANCE_URL = "http://www.google.com.hk/finance/match?q=%s"
    NEWLINE_RE = re.compile('\n')
    JSON_RE = re.compile('\{[\s]*\"matches\"[\s]*:[\s]*[[\s]*\{.*\}[\s]*\].*\}')

    BIG5HK_ENCODING = "big5hkscs"
    DEFAULT_ENCODING = BIG5HK_ENCODING

    def __init__(self, encoding=DEFAULT_ENCODING):
        self.encoding = encoding

    def getMatchesFromGFinance(self, queryString):
        encodedQueryString = urllib.quote(str(queryString))
        url = self.BASE_GFINANCE_URL % (encodedQueryString)
        connection = urllib2.urlopen(url)
        buffer = []
        while True:
            partialData = connection.read(self.BUFFER_SIZE)
            if not partialData:
                break
            buffer.append(partialData)
        connection.close()
        fromGoogle = "".join(buffer)

        fromGoogle = fromGoogle.decode(self.encoding).encode('utf-8')

        return fromGoogle

    def cleanUpDataFromGoogle(self, rawBuffer):
        cleaned = Util.removeNewLine(rawBuffer)
        cleaned = Util.convertTrueFalseCasing(cleaned)
        cleaned = Util.replaceHtmlCode(cleaned)
        return cleaned

    def convertToJson(self, cleaned):
        jsonString = self.JSON_RE.search(cleaned).group(0)
        jsonMatches =  Util.evalJson(jsonString, False)
        return jsonMatches

    def match(self, queryString):
        try:
            
            rawBuffer = self.getMatchesFromGFinance(queryString)
            cleaned = self.cleanUpDataFromGoogle(rawBuffer)
            jsonMatches = self.convertToJson(cleaned)

            matches = jsonMatches['matches']

            return matches
        except urllib2.HTTPError:
            print "Cannot open url for " + queryString
            return None
        except ValueError:
            exc_type, exc_value, exc_traceback = sys.exc_info()
            traceback.print_exception(exc_type, exc_value, exc_traceback,
                                      file=sys.stdout)
            print "Value Error\n" + rawBuffer
            return None

class StockMatchTableModel(PyQt4.Qt.QAbstractTableModel):

    HEADER = ["Ticker", "Name"]
    COL_TICKER = 0
    COL_NAME = 1

    ROLE_SUBTEXT1 = Qt.UserRole + 1

    COUNTRY_CN = '中国 China'
    COUNTRY_HK = '香港 Hong Kong'
    COUNTRY_US = 'United States'
    COUNTRY_UNKNOWN = 'Unknown'
    countryExchangeMap = {'HKG': COUNTRY_HK,
                         'SHA': COUNTRY_CN,
                         'SHE': COUNTRY_CN,
                         'NYSE': COUNTRY_US,
                         'NASDAQ': COUNTRY_US,
                         'AMEX': COUNTRY_US}

    def __init__(self, parent=None, *args):
        QAbstractTableModel.__init__(self, parent, *args)
        self.table = []

    def data(self, index, role):
        if not index.isValid():
            return QVariant()
        elif role != Qt.DisplayRole and role != self.ROLE_SUBTEXT1:
            return QVariant()

        row = self.table[index.row()]
        e = row['e']
        t = row['t']
        n = row['n']

        if index.column() is self.COL_TICKER:
            str = e + ":" + t
        elif index.column() is self.COL_NAME:
            if role == Qt.DisplayRole:
                str = n.decode('utf-8')
            elif role == self.ROLE_SUBTEXT1:
                country = self.getCountry(e).decode('utf-8')
                str = '%s (%s)' %(e, country)

        return QVariant(str)

    def getCountry(self, exchange):
        if self.countryExchangeMap.has_key(exchange):
            country = self.countryExchangeMap[exchange]
        else:
            country = self.COUNTRY_UNKNOWN

        return country

    def rowCount(self, parent):
        return len(self.table)

    def columnCount(self, parent):
        return len(self.HEADER)

    def add(self, matches):
        currentRowCount = self.rowCount(self.parent)
        self.beginInsertRows(QModelIndex(), currentRowCount, currentRowCount + len(matches) - 1)
        for match in matches:
          self.table.append(match)
        self.endInsertRows()

    def clear(self):
        self.beginRemoveRows(QModelIndex(), 0, self.rowCount(self.parent) - 1)
        self.table = []
        self.endRemoveRows()

    def reset(self, matches):
        if len(self.table) > 0:
            self.clear()
        self.add(matches)

    def headerData(self, col, orientation, role):
        if orientation == Qt.Horizontal and role == Qt.DisplayRole:
            return QVariant(self.HEADER[col])
        return QVariant()


class SMMainWindow(QMainWindow):

    PROP_FINGER_SCROLLABLE = "FingerScrollable"
    
    def __init__(self):
        QMainWindow.__init__(self)
        widget = QWidget(self)
        self.setCentralWidget(widget)
        self.hbox = QHBoxLayout(widget)
        self.vbox = QVBoxLayout()
        self.hbox.addLayout(self.vbox)

        self.lineEdit = QLineEdit()
        self.lookupButton = QPushButton("Lookup")
        self.collapseExpandButton = QPushButton("Hide Left Panel")
        self.showLeftPanel = True
        self.cnCheckbox = QCheckBox(u"中国 China")
        self.cnCheckbox.setChecked(True)
        self.hkCheckbox = QCheckBox(u"香港 Hong Kong")
        self.hkCheckbox.setChecked(True)
        self.usCheckbox = QCheckBox(u"United States")
        self.usCheckbox.setChecked(True)

        self.vbox.addWidget(self.lineEdit)
        self.vbox.addWidget(self.lookupButton)
        self.vbox.addWidget(self.collapseExpandButton)
        self.vbox.addWidget(self.cnCheckbox)
        self.vbox.addWidget(self.hkCheckbox)
        self.vbox.addWidget(self.usCheckbox)
        self.vbox.addStretch()

        self.model = StockMatchTableModel()
        self.table = QTableView()
        self.table.setModel(self.model)
        self.table.setMinimumWidth(480)
        self.table.setWordWrap(False)
        self.table.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
        self.table.horizontalHeader().setStretchLastSection(True)
        self.table.setProperty(self.PROP_FINGER_SCROLLABLE, True)

        self.delegate = StockMatchTableDelegate()
        self.table.setItemDelegate(self.delegate)

        self.stockMatcher = GFMatcher()
        self.hbox.addWidget(self.table)

        self.connect(self.lineEdit, SIGNAL("returnPressed()"), self.lookupButton.click)
        self.connect(self.lookupButton, SIGNAL("pressed()"), self.processNewQuery)
        self.connect(self.collapseExpandButton, SIGNAL("pressed()"), self.showHideLeftPanel)

    def processNewQuery(self):
        queryString = self.lineEdit.text()
        matches = self.stockMatcher.match(queryString)
        if matches is None:
            print queryString
        self.model.reset(matches)
        self.table.resizeRowsToContents()
        self.table.resizeColumnsToContents()
        self.lineEdit.setFocus(True)

    def showHideLeftPanel(self):
        if self.showLeftPanel:
            self.showLeftPanel = False
            self.lookupButton.hide()
            self.lineEdit.hide()
            self.cnCheckbox.hide()
            self.hkCheckbox.hide()
            self.usCheckbox.hide()
            self.collapseExpandButton.setText("+")
        else:
            self.showLeftPanel = True
            self.lookupButton.show()
            self.lineEdit.show()
            self.cnCheckbox.show()
            self.hkCheckbox.show()
            self.usCheckbox.show()
            self.collapseExpandButton.setText("Hide Left Panel")

        self.table.resizeRowsToContents()
        self.table.resizeColumnsToContents()


class StockMatch:
    def __init__(self):
        self.ui = SMMainWindow()
        self.ui.show()


if __name__ == '__main__':
    qtApp = QApplication(sys.argv)
    qtApp.setProperty("FingerScrollBars", False)
    app = StockMatch()
    sys.exit(qtApp.exec_())
