
#include "qemaemo5dynamicwidgethelper.h"
#include "qtsingleapplication.h"
#include "stickynoteswidget.hpp"
#include "appeventlistener.hpp"

#define SETTING_SAVED_WIDGETS_COMPATIBILITY "QMaemo5DynamicWidgetHelper-SavedWidgetIds"
#define SETTING_GREETING_MESSAGE_SHOWN "GreetingMessageShown - " + QApplication::applicationVersion()

int main(int argc, char *argv[])
{
    QApplication::setApplicationName("Sticky Notes");
    QApplication::setOrganizationName("Venemo");
    QApplication::setApplicationVersion("0.2.2 beta");

    QtSingleApplication app(argc, argv);
    qDebug() << "Launched Sticky Notes app";

    if (app.isRunning())
    {
        qDebug() << "Another instance of the app is running.";
        if (app.arguments().contains("in-background"))
        {
            qDebug() << "Closing that other instance.";
            app.sendMessage(APP_MESSAGE_CLOSE);
        }
        else
        {
            qDebug() << "Asking it to offer to create a new widget and closing this one.";
            app.sendMessage(APP_MESSAGE_ADDWIDGET);
            return 0;
        }
    }

    // Ensuring that notes from previous versions of the app are displayed in this version as well.
    QSettings settings;
    if (settings.allKeys().contains(SETTING_SAVED_WIDGETS_COMPATIBILITY))
    {
        settings.setValue(SETTING_SAVED_WIDGET_IDS, settings.value(SETTING_SAVED_WIDGETS_COMPATIBILITY));
        settings.remove(SETTING_SAVED_WIDGETS_COMPATIBILITY);
    }
    if (!settings.contains(SETTING_GREETING_MESSAGE_SHOWN) && QApplication::applicationVersion().contains("beta"))
    {
        settings.setValue(SETTING_GREETING_MESSAGE_SHOWN, true);
        QMessageBox::information(NULL, "Sticky Notes", "Thank you for installing and testing the beta version of Sticky Notes!");
    }

    app.setQuitOnLastWindowClosed(false);
    AppEventListener listener;
    QObject::connect(&app, SIGNAL(messageReceived(const QString&)), &listener, SLOT(receiveMessage(const QString&)));

    if (app.arguments().contains("forget-widgets"))
    {
        qDebug() << "We were asked to forget all widgets!";
        QeMaemo5DynamicWidgetHelper::globalInstance()->forgetAllWidgets();
    }
    else
    {
        qDebug() << "Restoring all widgets";
        QeMaemo5DynamicWidgetHelper::globalInstance()->restoreWidgets<StickyNotesWidget>();
    }

    if (!app.arguments().contains("in-background") && QeMaemo5DynamicWidgetHelper::globalInstance()->widgets().count() == 0)
    {
        qDebug() << "Adding a new widget, as there are none yet.";
        StickyNotesWidget::createAndShowNew();
    }

    return app.exec();
}
