#include "stickynoteswidget.hpp"
#include "ui_stickynoteswidget.h"

#define SETTING_NOTES_TEXT "StickyNotesText"
#define SETTING_NOTES_BG "StickyNotesBackground"
#define SETTING_SAVE_WAITINTERVAL 3000

void StickyNotesWidget::createAndShowNew()
{
    StickyNotesWidget *widget = new StickyNotesWidget();
    widget->show();
}

StickyNotesWidget::StickyNotesWidget(QWidget *parent)
    : QMaemo5DynamicHomescreenWidget(false, parent),
    ui(new Ui::StickyNotesWidget),
    _color(QColor(0, 0, 0, 185)),
    _isChanged(false),
    _timer(new QTimer(this))
{
    ui->setupUi(this);
    ui->txtNote->setInputMethodHints(Qt::ImhNone);

    _timer->setInterval(SETTING_SAVE_WAITINTERVAL);
    _timer->setSingleShot(true);
    connect(_timer, SIGNAL(timeout()), this, SLOT(saveText()));
}

StickyNotesWidget::~StickyNotesWidget()
{
    delete ui;
}

void StickyNotesWidget::paintEvent(QPaintEvent *event)
{
    QPainter p(this);
    p.setBrush(_color);
    p.setPen(Qt::NoPen);
    QRect myRect(rect().left() + 8, rect().top(), rect().width() - 16, rect().height() - 65);
    p.drawRect(myRect);

    QWidget::paintEvent(event);

    if (!isPositionLoaded())
    {
        loadPosition();
    }
}

void StickyNotesWidget::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type())
    {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void StickyNotesWidget::showSettingsDialog()
{
    //QMessageBox::information(0, "hey", "this is the sticky notes settings");
}

bool StickyNotesWidget::restoreWidgetState()
{
    QString str = loadSetting(SETTING_NOTES_TEXT).toString();
    ui->txtNote->setPlainText(str);
    _color = loadSetting(SETTING_NOTES_BG, QColor(0, 0, 0, 185)).value<QColor>();
    return true;
}

void StickyNotesWidget::saveText()
{
    if (_isChanged)
    {
        _isChanged = false;
        saveSetting(SETTING_NOTES_TEXT, ui->txtNote->toPlainText());
        qDebug() << "saved text for " << appletId();
    }
}

bool StickyNotesWidget::isChanged()
{
    return _isChanged;
}

void StickyNotesWidget::on_btnAdd_clicked()
{
    StickyNotesWidget *newWidget = new StickyNotesWidget();
//    newWidget->saveSetting(WIDGET_SETTINGS_POSITION_X, pos().x() + 30);
//    newWidget->saveSetting(WIDGET_SETTINGS_POSITION_Y, pos().y() + 30);
    newWidget->_color = _color;
    newWidget->show();
}

void StickyNotesWidget::on_btnOptions_clicked()
{
    QColor newColor = QColorDialog::getColor(_color, 0, "Sticky note color");
    newColor.setAlpha(185);
    _color = newColor;
    saveSetting(SETTING_NOTES_BG, _color);
    update();
}

void StickyNotesWidget::on_btnExit_clicked()
{
    close();
}

void StickyNotesWidget::on_txtNote_textChanged()
{
    _isChanged = true;
    _timer->start();
}
