
#include "qmaemo5dynamicwidgethelper.h"
#include "qtsingleapplication.h"
#include "stickynoteswidget.hpp"
#include "appeventlistener.hpp"

int main(int argc, char *argv[])
{
    QApplication::setApplicationName("Sticky Notes");
    QApplication::setOrganizationName("Venemo");

    QtSingleApplication app(argc, argv);
    qDebug() << "Launched Sticky Notes app";

    if (app.isRunning())
    {
        qDebug() << "Another instance of the app is running.";
        if (app.arguments().contains("in-background"))
        {
            qDebug() << "Closing that.";
            app.sendMessage(APP_MESSAGE_CLOSE);
        }
        else
        {
            qDebug() << "Asking it to offer to create a new widget and closing this one.";
            app.sendMessage(APP_MESSAGE_ADDWIDGET);
            return 0;
        }
    }

    app.setQuitOnLastWindowClosed(false);
    AppEventListener listener;
    QObject::connect(&app, SIGNAL(messageReceived(const QString&)), &listener, SLOT(receiveMessage(const QString&)));

    if (app.arguments().contains("forget-widgets"))
    {
        qDebug() << "We were asked to forget all widgets!";
        QMaemo5DynamicWidgetHelper::globalInstance()->forgetAllWidgets();
    }
    else
    {
        qDebug() << "Re-adding all widgets";
        QMaemo5DynamicWidgetHelper::globalInstance()->reAddWidgets<StickyNotesWidget>();
    }

    if (!app.arguments().contains("in-background") && QMaemo5DynamicWidgetHelper::globalInstance()->widgets().count() == 0)
    {
        qDebug() << "Adding a new widget, as there are none yet.";
        StickyNotesWidget *widget = new StickyNotesWidget();
        widget->show();
    }

    return app.exec();
}
