#!/bin/sh
# 
# SSH status / switcher modified by 
# Andrei Emeltchenko (2010) and 
# Serhiy Zahoriya (2013), based upon:
# Wifi switcher for N900  Copyright (C) 2010 by Tito Ragusa 
# <farmatito@tiscali.it>
#
#This file is part of ssh-status.

#ssh-status is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.

#ssh-status is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with ssh-status.  If not, see <http://www.gnu.org/licenses/>.
#
# Please read the COPYING and README file.

debug=1

print_msg()
{
  run-standalone.sh dbus-send --print-reply  \
  --type=method_call --dest=org.freedesktop.Notifications  \
  /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog \
  string:"$1" uint32:0 string:'$2'
}


print_failed_and_die()
{
  if [ $debug -eq "1" ] ; then
    print_msg "Failed to $action SSH$step" "KO"
  else
    print_msg "Failed to $action SSH" "KO"
  fi
  exit 1
}

if [ "$1" = "check" ] ; then
  if [ `pidof sshd` -gt "0" ] ; then
  # SSH running
    exit 0
  else
    exit 2
  fi

elif [ "$1" = "kill" ] ; then
  killall sshd

else

# Toggle SSH server status
  if [ `pidof sshd` -gt "0" ] ; then
    # SSH running, stop it
    action="disable"
    stop sshd
    if [ `pidof sshd` -gt "0" ] ; then
      step=": stop failed"
      print_failed_and_die
    fi

    print_msg "SSH stopped" "OK"

    exit 2
  else
    # SSH stopped, run it
    action="enable"
    step=":$(start sshd 2>&1 >/dev/null)"
    if [ `pidof sshd` -gt "0" ] ; then
      print_msg "SSH started" "OK"
      exit 0
    fi
    print_failed_and_die
  fi

fi
