#!/bin/sh
# 
# SSH status / switcher modified by Andrei Emeltchenko based upon:
# Wifi switcher for N900  Copyright (C) 2010 by Tito Ragusa <farmatito@tiscali.it>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Please read the COPYING and README file!!!

debug=1

print_msg()
{
	run-standalone.sh dbus-send --print-reply  \
	--type=method_call --dest=org.freedesktop.Notifications  \
	/org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog \
	string:"$1" uint32:0 string:'$2'
}


print_failed_and_die()
{
	if [ $debug -eq "1" ] ; then
		print_msg "Failed to $action SSH$step" "KO"
	else
		print_msg "Failed to $action SSH" "KO"
	fi
	exit 1
}

if [ "$1" = "check" ] ; then
	if [ `status sshd | grep -c running` -gt "0" ] ; then
	# SSH running
		exit 0
	else
		exit 2
	fi

else


if [ `status sshd | grep -c running` -gt "0" ] ; then
	# SSH running, stop it
	action="disable"
	stop sshd
	if [ $? -ne "0" ] ; then
		step=": stop failed"
		print_failed_and_die
	fi
	
	print_msg "SSH stopped OK" "OK"
	
	exit 2
else
	# SSH stopped, run it
	action="enable"
	start sshd
	if [ $? -ne "0" ] ; then
		step=": start failed"
		print_failed_and_die
	fi

	print_msg "SSH started OK" "OK"
	
	exit 0
fi

fi
