#include "optionsdialog.h"
#include "ui_optionsdialog.h"

OptionsDialog::OptionsDialog(const QVariantMap &settings, const QString& coreVersion, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::OptionsDialog)
{
    cVersion=coreVersion;
    ui->setupUi(this);
    lSettings=QVariantMap(settings);
    ui->ssaverCheckBox->setChecked(lSettings.value("screensaverinhibited").toBool());
    ui->albumIconsCheckBox->setChecked(lSettings.value("albumicons").toBool());
    ui->largeAlbumIconsCheckBox->setChecked(lSettings.value("largealbumicons").toBool());
    ui->ssaverCheckBox->setChecked(lSettings.value("screensaverinhibited").toBool());
}

OptionsDialog::~OptionsDialog()
{
    delete ui;
}

void OptionsDialog::on_buttonBox_accepted()
{
    lSettings["screensaverinhibited"]=ui->ssaverCheckBox->isChecked();
    lSettings["albumicons"]=ui->albumIconsCheckBox->isChecked();
    lSettings["largealbumicons"]=ui->largeAlbumIconsCheckBox->isChecked();
    lSettings["screensaverinhibited"]=ui->ssaverCheckBox->isChecked();
    emit accepted(lSettings);
}


void OptionsDialog::on_aboutPushButton_clicked()
{
    //----------------------------------------------
    // OptionsDialog::showAbout()
    // Opens a message display with the "About"
    // information.
    //----------------------------------------------
//    void squeezster::showAbout() {
        QString aboutString = "Squeezster v.";
        aboutString+=VERSION;
        aboutString+="\n";
        // aboutString+="Squeezster Core v.";
        // aboutString+=cVersion;
        // aboutString+="\n";
        aboutString+="By Patrik Karlsson 2012";
    #if defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
        QMessageBox::information(this, tr("About Squeezster"),
                                 tr(aboutString.toLatin1()));
    #else
        //QMessageBox::information(this, tr("About Squeezster"),
        //                         tr(aboutString.toLatin1()));
    #endif
  //  }
  //  emit showAbout();
}
