#ifndef CONNECTIONDIALOG_H
#define CONNECTIONDIALOG_H

#include <QDialog>
#include <QtDebug>
#include <QVariantMap>

namespace Ui {
    class connectionDialog;
}

class connectionDialog : public QDialog
{
    Q_OBJECT

public:
    explicit connectionDialog(const QVariantMap& oldSettings, const QVariantList &lServerList, QWidget *parent);
    ~connectionDialog();
    void setServerList(const QVariantList& serverList) {serverList_i=serverList;emit serverListChanged();}
    QVariantList serverList() {return serverList_i;}


signals:
    void connectionSettingsUpdated(QVariantMap settings);
    void coreRestartRequest();
    void constructWolDialog(QVariantMap settings);
    void serverListChanged();

private:
    Ui::connectionDialog *ui;
    QString wolMac_i;
    quint16 wolPort_i;
    QVariantMap lOldSettings;
    QVariantList serverList_i;


private slots:
    void updateIpAddressComboBox();
    void on_currentIndex_changed(int index);
    void on_wolPushButton_clicked();
    void on_acceptPushButton_clicked();
    void on_mysbRadioButton_toggled(bool checked);
};

#endif // CONNECTIONDIALOG_H
