#ifndef XMLTREEITEM_H
#define XMLTREEITEM_H

#include <QTreeWidgetItem>
#include <QHash>
#include <QVariant>
#include <QtDebug>
#include "squeezster_icons.h"
#include "metatypes.h"

//#include "squeezster.h"


typedef QVariantHash* variantHash_ptr;

class xmlTreeItem : public QTreeWidgetItem

{
    //Q_OBJECT
public:
    //enum {Type = QTreeWidgetItem::UserType+1 };
    enum {Type = 1000 };
    explicit xmlTreeItem();
    ~xmlTreeItem() {delete hash;}

    static const int xmlItemCol = 0;
    static const int xmlItem = 128;
    void addProperty(QString key, QString val);
    QString property(QString key);
    QString text() {return(QTreeWidgetItem::text(0));}
    void setIcon();
    void setIcon(QIcon icon) {QTreeWidgetItem::setIcon(0,icon);}
    QString command() {return(property("cmd"));}
    QString id() {return(property("id"));}
    QString item_id() {
        if (!property("id").isEmpty())
            return(QString("item_id:"+property("id")));
        else return(QString());}
    QString album_id() {
        if(!property("album").isEmpty())
            return(QString("album_id:"+property("id")));
        else return(QString());}

    QString folder_id() {
        if(property("type")==QString("folder"))
            return(QString("folder_id:"+property("id")));
        else return(QString());}

    QString track_id() {
        if(property("type")==QString("track"))
            return(QString("track_id:"+property("id")));
        else return(QString());}
    QString title_id() {
        if(!property("title").isEmpty())
            return(QString("track_id:"+property("id")));
        else return(QString());}

    QString artist_id() {
        if(!property("artist").isEmpty())
            return(QString("artist_id:"+property("id")));
        else return(QString());}

    QString playlist_id() {
        if(!property("playlist").isEmpty())
            return(QString("playlist_id:"+property("id")));
        else return(QString());
    }
    QString genre_id() {return(QString("genre_id:"+property("id")));}

    //int id() {return(property("id").toInt());}
    int hasItems() {return(property("hasitems").toInt());}
    int isAudio() {return(property("isaudio").toInt());}
    bool isXmlBrowser() {return(property("type")==QString("xmlbrowser")?true:false);}
    bool typeFolder() {return(property("type")==QString("folder")?true:false);}
    bool typeTrack() {return(property("type")==QString("track")?true:false);}
    bool typeAudio() {return(property("type")==QString("audio")?true:false);}
    QIcon icon() {return(QTreeWidgetItem::icon(xmlItemCol));}
    QString name() {return(property("name"));}
    QString title() {return(property("title"));}

signals:

public slots:


private:
    QVariant variant;
    QVariantHash* hash;
};


//Q_DECLARE_METATYPE(QVariantHash*)
Q_DECLARE_METATYPE(xmlTreeItem)
Q_DECLARE_METATYPE(xmlTreeItem*)
#endif // XMLTREEITEM_H
