#include "xmltreeitem.h"

xmlTreeItem::xmlTreeItem() :
        QTreeWidgetItem(Type)
{
    hash=new QVariantHash();
    qVariantSetValue(variant,hash);
    setData(xmlItemCol,xmlItem,variant);
}


void xmlTreeItem::addProperty(QString key, QString val)
{
    QVariant propVariant;
    qVariantSetValue(propVariant,val);
    QVariantHash* hash=QVariant(data(xmlItemCol,xmlItem)).value<QVariantHash*>();
    hash->insert(key.toLower(),propVariant);
    //qDebug() << "addProperty" << key << val;
    if(property("cmd")==QString("favorites")) {
        if((key==QString("title")) || (key==QString("name"))) {
            setText(xmlItemCol,val);
        }
    }
    else if(property("cmd")==QString("titles")) {
        if(key==QString("title")) {
            setText(xmlItemCol,QString(val));
        }
    }
    else if(property("cmd")==QString("artists")) {
        if(key==QString("artist")) {
            setText(xmlItemCol,QString(val));
        }
    }
    else if(property("cmd")==QString("musicfolder")) {
        if(key==QString("filename")) {
            setText(xmlItemCol,QString(val));
        }
    }
    else if(key==QString("name"))
        setText(xmlItemCol,val);
    else if(key==QString("filename"))
        setText(xmlItemCol,val);
}

QString xmlTreeItem::property(QString key)
{
    QVariantHash* hash;
    QVariant variant = data(xmlItemCol,xmlItem);
    if (variant.isValid() && variant.canConvert<QVariantHash*>())
        hash = variant.value<QVariantHash*>();
    else
        return(QString());
    QVariant propVariant;
    propVariant = hash->value(key.toLower());
    return(propVariant.toString());

}

void xmlTreeItem::setIcon()
{
    if(command()==QString("musicfolder")) {
        if(typeFolder())
            setIcon(QIcon(MUSICNOTESPIXMAPFILE));
        if(typeTrack())
            setIcon(QIcon(WHITENOTEPIXMAPFILE));
    }
    else if(!hasItems()) {
        (isAudio()?setIcon(QIcon(WHITENOTEPIXMAPFILE)):setIcon(QIcon(SMALLBULLETPIXMAPFILE)));}
    else
        setIcon(QIcon(MUSICNOTESPIXMAPFILE));
}


