#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "LocationModule.h"
#include <QTimer>
float speed=0;
extern SpeedoMeter *pW;
float trip=0;
float total=0;
int appClose=0;
float average_speed=0;
float seconds=0;
//LocationThread l;


SpeedoMeter::SpeedoMeter(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::SpeedoMeter)
{
    ui->setupUi(this);
    unit = 0;
    //ui->lcdNumber->display(speed);
    //ui->lcdNumber->setBaseSize(32,32);

    ui->lcdNumber_3->setDigitCount(7);
    ui->lcdNumber_2->setDigitCount(7);
    ui->lcdNumber->setDigitCount(7);
    ui->lcdNumber_4->setDigitCount(10);

    // load total distance from a file
    FILE *fp=fopen("/home/user/.speedrec","r");
    if(0!=fp)
    {
        fscanf(fp,"%f",&total);
        fclose(fp);
    }
    hour=min=sec=tensofsec=0;
    started=0;paused=0;
    QTimer *t=new QTimer(this);
    connect(t,SIGNAL(timeout()),this,SLOT(updateLocation()) );
    t->start(1000);
    QTimer *t2=new QTimer(this);
    connect(t2,SIGNAL(timeout()),this,SLOT(updateTime()) );
    t2->start(100);

}

SpeedoMeter::~SpeedoMeter()
{
    delete ui;
    FILE *fp=fopen("/home/user/.speedrec","w");
    if(0!=fp)
    {
        fprintf(fp,"%f",total);
        fclose(fp);
    }
    stopLocation();
}

void SpeedoMeter::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SpeedoMeter::on_pushButton_clicked()
{
    trip=0;
}
void SpeedoMeter::start_gps()
{
   initLocation();
}
void SpeedoMeter::updateLocation()
{
    speed = locationModuleVar_Speed;
    //speed++;
    float mpersec = (float)(speed)/3600*1000;
    //float delta_dist = mpersec;
    trip += mpersec/1000;
    total+=mpersec/1000;

    if(seconds>5.0f)
        average_speed = (trip*1000)/seconds;
    else
        average_speed=0;
    average_speed*=3.6f; // km / h
    int d_speed;
    float d_trip;
    float d_total;
    float d_average;
    if(unit==0)
    {
        ui->label->setText("km/h");
        ui->label_2->setText("km (trip)");
        ui->label_3->setText("km");
        ui->label_5->setText("km/h");
        d_speed=(int)speed;
        d_trip = trip;
        d_total=total;
        d_average = average_speed;

    }
    else
    {
        d_speed =(int)(speed/1.609);
        d_trip = trip/1.609;
        d_total=total/1.609;
        d_average=average_speed/1.609;
        ui->label->setText("mph");
        ui->label_2->setText("mi (trip)");
        ui->label_3->setText("mi");
        ui->label_5->setText("mph");

    }

    char buf[20];
    ui->lcdNumber->display(d_speed);
    sprintf(buf,"%.2f",d_trip);
    // replace , with . for QLcdNumber
    for(int i=0;i<strlen(buf);i++){
        if(buf[i]==',')buf[i]='.';}
    ui->lcdNumber_2->display(QString(buf));
    sprintf(buf,"%.2f",d_total);
    // replace , with . for QLcdNumber
    for(int i=0;i<strlen(buf);i++){
        if(buf[i]==',')buf[i]='.';}
    ui->lcdNumber_3->display(QString(buf));

    sprintf(buf,"%.2f",d_average);
    // replace , with . for QLcdNumber
    for(int i=0;i<strlen(buf);i++){
        if(buf[i]==',')buf[i]='.';}
    ui->lcdNumber_5->display(QString(buf));

}

void SpeedoMeter::updateTime()
{

char buf[80];char h[3],m[3],s[3];
if(hour<10)sprintf(h,"0%d",hour);else sprintf(h,"%d",hour);
if(min<10)sprintf(m,"0%d",min);else sprintf(m,"%d",min);
if(sec<10)sprintf(s,"0%d",sec);else sprintf(s,"%d",sec);

sprintf(buf,"%s.%s.%s.%d",h,m,s,tensofsec);
ui->lcdNumber_4->display(QString(buf));
    if(!started)return;
    if(paused)return;
    tensofsec++;
    if(tensofsec==10)
    {
       tensofsec=0;sec++;seconds++;
       if(sec==60)
       {
           sec=0;min++;
           if(min==60)
           {
               min=0;hour++;
           }
       }
    }

}

void SpeedoMeter::on_pushButton_2_clicked()
{
    unit = 1-unit; // 0 km, 1-miles
}

void SpeedoMeter::on_startTimeButton_clicked()
{
    started=1;paused=0;

}

void SpeedoMeter::on_pauseTimeButton_clicked()
{
    if(paused){
        hour=min=sec=tensofsec=seconds=0;started=0;average_speed=0;
    }
    paused=1-paused;

}
