#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
#include "LocationModule.h"


// exported variables
int locationModuleVar_Speed;
int gpsActive=0;
extern int appClose;
LocationGPSDControl *control;
LocationGPSDevice *device;
static void on_error(LocationGPSDControl *control, LocationGPSDControlError error, gpointer data)
{
}

static void on_changed(LocationGPSDevice *device, gpointer data)
{
        if (!device)
                return;

        if (device->fix) {
            gpsActive = 1;
                if (device->fix->fields & LOCATION_GPS_DEVICE_SPEED_SET) {
                    g_debug("speed:%d", device->fix->speed);

                    locationModuleVar_Speed = device->fix->speed;

                }
        }

    }

static void on_stop(LocationGPSDControl *control, gpointer data)
{
        //g_debug("quitting");
}

static gboolean start_location(gpointer data)
{
        return FALSE;
}

void stopLocation()
{
    location_gpsd_control_stop((LocationGPSDControl *) control);
    g_object_unref(device);
    g_object_unref(control);

}

void initLocation()
{




           g_type_init();


            control = location_gpsd_control_get_default();
            device = (LocationGPSDevice*)g_object_new(LOCATION_TYPE_GPS_DEVICE, 0);

            g_object_set(G_OBJECT(control),
                    "preferred-method", LOCATION_METHOD_USER_SELECTED,
                    "preferred-interval", LOCATION_INTERVAL_1S,
                    NULL);

            g_signal_connect(control, "error-verbose", G_CALLBACK(on_error), 0);
            g_signal_connect(device, "changed", G_CALLBACK(on_changed), control);
            g_signal_connect(control, "gpsd-stopped", G_CALLBACK(on_stop), 0);

            location_gpsd_control_start(control);
            //g_debug("quitting...");




}
