#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "LocationModule.h"
#include <QTimer>
float speed=0;
extern SpeedoMeter *pW;
float trip=0;
float total=0;
int appClose=0;
//LocationThread l;


SpeedoMeter::SpeedoMeter(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::SpeedoMeter)
{
    ui->setupUi(this);
    unit = 0;
    //ui->lcdNumber->display(speed);
    //ui->lcdNumber->setBaseSize(32,32);

    ui->lcdNumber_3->setDigitCount(7);
    ui->lcdNumber_2->setDigitCount(7);
    ui->lcdNumber->setDigitCount(7);

    // load total distance from a file
    FILE *fp=fopen("/home/user/.speedrec","r");
    if(0!=fp)
    {
        fscanf(fp,"%f",&total);
        fclose(fp);
    }

    QTimer *t=new QTimer(this);
    connect(t,SIGNAL(timeout()),this,SLOT(updateTime()) );
    t->start(1000);

}

SpeedoMeter::~SpeedoMeter()
{
    delete ui;
    FILE *fp=fopen("/home/user/.speedrec","w");
    if(0!=fp)
    {
        fprintf(fp,"%f",total);
        fclose(fp);
    }
    stopLocation();
}

void SpeedoMeter::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SpeedoMeter::on_pushButton_clicked()
{
    trip=0;
}
void SpeedoMeter::start_gps()
{
   initLocation();
}
void SpeedoMeter::updateTime()
{
    speed = locationModuleVar_Speed;
    //speed++;
    float mpersec = (float)(speed)/3600*1000;
    float delta_dist = mpersec;
    trip += mpersec/1000;
    total+=mpersec/1000;

    int d_speed;
    float d_trip;
    float d_total;
    if(unit==0)
    {
        ui->label->setText("km/h");
        ui->label_2->setText("km (trip)");
        ui->label_3->setText("km");
        d_speed=(int)speed;
        d_trip = trip;
        d_total=total;

    }
    else
    {
        d_speed =(int)(speed/1.609);
        d_trip = trip/1.609;
        d_total=total/1.609;
        ui->label->setText("mph");
        ui->label_2->setText("mi (trip)");
        ui->label_3->setText("mi");

    }

    char buf[20];
    ui->lcdNumber->display(d_speed);
    sprintf(buf,"%.2f",d_trip);
    ui->lcdNumber_2->display(QString(buf));
    sprintf(buf,"%.2f",d_total);
    ui->lcdNumber_3->display(QString(buf));

}


void SpeedoMeter::on_pushButton_2_clicked()
{
    unit = 1-unit; // 0 km, 1-miles
}
