#include "noteswindow.h"
#include "ui_noteswindow.h"
#include "friendswindow.h"

NotesWindow::NotesWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::NotesWindow),
    accessToken(token),
    qfacebook(new QFacebook(token, this))
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    connect(ui->notesList, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(onItemActivated(QListWidgetItem*)));
    connect(ui->actionNew_note, SIGNAL(triggered()), this, SLOT(createNote()));
}

NotesWindow::~NotesWindow()
{
    delete ui;
}

void NotesWindow::refreshNotes()
{
    browseNotes(m_userId);
}

void NotesWindow::browseNotes(QString userId)
{
    m_userId = userId;
    reply = qfacebook->getConnections(userId, "notes&fields=subject");
    if (reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void NotesWindow::onReplyReceived()
{
    if (reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch notes!";
        reply->deleteLater();
        reply = 0;

        return;
    }

    QVariant jsonData = reply->data();
    QVariantList listData = jsonData.toMap().value("data").toList();

    ui->notesList->clear();

    foreach (jsonData, listData) {
        QListWidgetItem *item = new QListWidgetItem(ui->notesList);
        item->setData(Qt::UserRole, jsonData.toMap().value("id").toString());
        item->setText(jsonData.toMap().value("subject").toString());
    }
}

void NotesWindow::onItemActivated(QListWidgetItem *item)
{
    NoteWindow *note = new NoteWindow(this, accessToken);
    note->setWindowTitle(item->text());
    note->textEdit()->setText(tr("Loading..."));
    note->showNote(item->data(Qt::UserRole).toString());
#ifdef Q_WS_S60
    note->showMaximized();
#else
    note->show();
#endif
}

void NotesWindow::createNote()
{
    NewNoteDialog *dialog = new NewNoteDialog(this, accessToken);
    connect(dialog, SIGNAL(createNote(QString,QString)), this, SLOT(onCreateNote(QString,QString)));
    dialog->show();
}

void NotesWindow::onCreateNote(QString subject, QString id)
{
    NoteWindow *window = new NoteWindow(this, accessToken);
    window->setCreateMode(subject, id);
    window->show();
}
