#ifndef NEWSFEEDPOST_H
#define NEWSFEEDPOST_H

#include <QWidget>
#include <QNetworkAccessManager>
#include <QDesktopWidget>
#include <QDebug>
#include <QDateTime>
#include <QPainter>
#include <QMainWindow>
#include <QPropertyAnimation>
#include <QMessageBox>
#include <QMenu>
#include <QClipboard>
#include <QSettings>
#include <QDesktopServices>
#include <QFile>
#include <QDir>
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif
#include <qfacebook.h>

#include "youtubeplayer.h"

namespace Ui {
    class NewsFeedPost;
}

class NewsFeedPost : public QWidget
{
    Q_OBJECT

public:
    explicit NewsFeedPost(QWidget *parent = 0, QString token = "0", QFacebook *qfacebook = 0, QNetworkAccessManager *nam = 0);
    ~NewsFeedPost();
    void setName(QString name);
    void setDate(QString date);
    void setAvatar(QPixmap pixmap);
    void setMessage(QString message);
    void setId(QString id);
    void getPixmapFromUrl(QString pixmapUrl);
    void setIconFromUrl(QString url);
    void setNumberOfLikesComments(QString likes, QString comments);
    void hideBottomBar(bool hide);
    void setLikedByMe(bool liked);
    void setTime(QString time);
    void setDeletable(bool deletable);
    void setUserId(QString id);
    void setCommentMode(bool isComment);
    void setMessageMode(bool isMessage);
    void setTimeFromString(QString timeAsString);
    void getPixmapFromUserId(QString userId);
    void addLink(QString url, QString linkName, QString linkDescription, QString linkPixmap);
    void setToName(QString name, QString id);
    void setType(QString type);
    void setObjectId(QString objectId);
    QString postId();
    QString type();

protected:
    void paintEvent(QPaintEvent *);
    void resizeEvent(QResizeEvent *);
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);
    void showEvent(QShowEvent *);

signals:
    void commentButtonClicked(QString id, QString comments, QString likes);
    void likeButtonClicked(QString id, QString comments, QString likes);
    void nameClicked(QString id, QString name);
    void postDeleted(QString id);
    void clicked(QString id);
    void pressed();
    void released();

private:
    Ui::NewsFeedPost *ui;
    QString accessToken;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QNetworkReply *deleteReply;
    QString id;
    QNetworkAccessManager *nam;
    QNetworkReply *pictureReply;
    QString m_numberOfComments;
    QString likes;
    QString userId;
    QString m_toUserId;
    QString m_postType;
    QString m_objectId;
    QString m_linkUrl;
    bool m_isLikedByMe;
    bool m_isDeletable;
    bool m_isComment;
    bool m_pressed;
    bool m_whiteMode;

private slots:
    void avatarReceived();
    void onPictureReceived();
    void iconReceived();
    void orientationChanged();
    void onLikeButtonClicked();
    void onCommentButtonClicked();
    void onLikeReplyReceived();
    void onDeleteButtonClicked();
    void onDeleteReplyReceived();
    void onNameClicked();
    void copyPost();
    void showContextMenu(QPoint point);
    void onToNameClicked();
    void onLinkActivated(QString url);
    void onPhotoClicked();
};

#endif // NEWSFEEDPOST_H
