#ifndef NOTIFICATIONITEM_H
#define NOTIFICATIONITEM_H

#include <QWidget>
#include <QMouseEvent>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QPropertyAnimation>
#include <QPainter>
#include <QDebug>
#include <QFile>
#include <QDir>
#include <QDesktopServices>

namespace Ui {
    class NotificationItem;
}

class NotificationItem : public QWidget
{
    Q_OBJECT

public:
    explicit NotificationItem(QWidget *parent = 0, QString token = "0", QNetworkAccessManager *nam = 0);
    ~NotificationItem();
    bool isPressed();
    QString objectId();
    QString userId();
    QString text();
    QString objectType();
    QString notificationId();
    void setObjectId(QString id);
    void setUserId(QString id);
    void setText(QString text);
    void setNotificationId(QString notificationId);
    void setObjectType(QString objectType);
    void setUnread(bool);
    bool isUnread();

public slots:
    void markAsRead();

protected:
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);
    void paintEvent(QPaintEvent *);

signals:
    void pressed();
    void released();
    void clicked(NotificationItem *);
    void markedAsRead(NotificationItem *);

private:
    Ui::NotificationItem *ui;
    QString accessToken;
    QString m_userId;
    QString m_objectId;
    QString m_objectType;
    QString m_notificationId;
    bool m_pressed;
    QNetworkAccessManager *nam;
    QNetworkReply *avatarReply;
    QNetworkReply *m_markAsReadReply;
    bool m_unread;

private slots:
    void onAvatarReceived();
    void getAvatar();
    void markAsReadReply();
};

#endif // NOTIFICATIONITEM_H
