#ifndef PHOTOWINDOW_H
#define PHOTOWINDOW_H

#include <QMainWindow>
#include <QNetworkAccessManager>
#include <QDebug>
#include <QFileDialog>
#include <QPointer>
#include <qfacebook.h>
#include "newsfeedpost.h"

namespace Ui {
    class PhotoWindow;
}

class PhotoWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit PhotoWindow(QWidget *parent = 0, QString token = "0");
    ~PhotoWindow();
    void showPhoto(QString photoId);
    void setPhoto(QString filename);
    void showPhotoFromId(QString id);
    void setPixmapFromUrl(QString url);
    void setPhotoId(QString id);
    void setUserId(QString userId);
    void setPixmap(QPixmap pixmap);
    void setComments(QVariantList comments);
    void setTags(QVariantList tags);
    void getCommentsForPhoto(QString id);

private:
    Ui::PhotoWindow *ui;
    QFacebook *qfacebook;
    QNetworkReply *reply;
    QFacebookReply *commentsReply;
    QFacebookReply *commentReply;
    QString accessToken;
    QNetworkAccessManager *nam;
    QNetworkReply *m_downloadReply;
    QString photoId;
    QString m_userId;
    QVariantList m_comments;
    QVariantList m_tags;
    QString m_photoUrl;
    QString m_downloadLocation;
    QString m_myId;
    QList<NewsFeedPost*> commentsList;

private slots:
    void onReplyReceived();
    void onClicked(QPoint);
    void downloadPhoto();
    void onDownloadFinished();
    void onGotComments();
    void onCommentButtonClicked();
    void onCommentReplyReceived();
    void onCommentDeleted(QObject *pointer);
};

#endif // PHOTOWINDOW_H
