#include "loginwindow.h"
#include "ui_loginwindow.h"

LoginWindow::LoginWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::LoginWindow)
{
    ui->setupUi(this);
    QString url = QString(authUrl).arg(permissionsList().join(",")).arg(appId);
    qDebug() << url;
    QString cookieDir = QDesktopServices::storageLocation(QDesktopServices::DataLocation);
    QDir dir = QDir(cookieDir);
    if (!dir.exists())
        dir.mkpath(cookieDir);
    QString cookieFile = cookieDir + "/facebook.cookies";
    CookieJar *cookieJar = new CookieJar(cookieFile);
    ui->webView->page()->networkAccessManager()->setCookieJar(cookieJar);
    ui->webView->setUrl(QUrl(url));
    connect(ui->webView, SIGNAL(urlChanged(QUrl)), this, SLOT(onUrlChanged(QUrl)));
    connect(ui->webView, SIGNAL(loadFinished(bool)), this, SLOT(onInitalLoadFinished(bool)));
    connect(ui->webView, SIGNAL(loadProgress(int)), ui->progressBar, SLOT(setValue(int)));
    connect(ui->webView, SIGNAL(loadStarted()), this, SLOT(onLoadStarted()));
    connect(ui->webView, SIGNAL(loadFinished(bool)), this, SLOT(onLoadFinished(bool)));
    setAttribute(Qt::WA_DeleteOnClose);
    disableCloseButton = false;
    isLoggingIn = false;
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
    QWebViewSelectionSuppressor *suppressor = new QWebViewSelectionSuppressor(ui->webView);
    suppressor->enable();
#endif
}

LoginWindow::~LoginWindow()
{
    delete ui;
}

void LoginWindow::onInitalLoadFinished(bool)
{
    disconnect(ui->webView, SIGNAL(loadFinished(bool)), this, SLOT(onInitalLoadFinished(bool)));
}

void LoginWindow::onLoadStarted()
{
    isLoggingIn = true;
    ui->widget->show();
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
}

void LoginWindow::onUrlChanged(QUrl url)
{
    if (url.toString().contains("https://www.facebook.com/connect/login_success.html#access_token=")) {
        QString urlString = url.toString();
        QString accessToken = urlString.remove("https://www.facebook.com/connect/login_success.html#access_token=").remove("&expires_in*");
        int position = accessToken.indexOf('&');
        accessToken = accessToken.remove(position, accessToken.length()-position);
        emit loggedIn(accessToken);
        this->onLoggedIn();
    }
}

void LoginWindow::onLoggedIn()
{
    disableCloseButton = false;
    this->close();
}

void LoginWindow::closeEvent(QCloseEvent *e)
{
    if (disableCloseButton)
        e->ignore();

    if (!isLoggingIn)
        qApp->closeAllWindows();
}

void LoginWindow::onLoadFinished(bool)
{
    ui->widget->hide();
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

QStringList LoginWindow::permissionsList()
{
    QStringList permissions;
    permissions << "user_photo_video_tags";
    permissions << "friends_photo_video_tags";
    permissions << "user_notes";
    permissions << "friends_notes";
    permissions << "publish_checkins";
    permissions << "user_checkins";
    permissions << "friends_checkins";
    permissions << "create_event";
    permissions << "user_events";
    permissions << "rsvp_event";
    permissions << "friends_events";
    permissions << "user_groups";
    permissions << "friends_groups";
    permissions << "manage_pages";
    permissions << "user_photos";
    permissions << "friends_photos";
    permissions << "read_stream";
    permissions << "offline_access";
    permissions << "publish_stream";
    permissions << "read_mailbox";
    permissions << "friends_birthday";
    permissions << "friends_relationships";
    permissions << "user_relationships";
    permissions << "user_relationship_details";
    permissions << "friends_relationship_details";
    permissions << "user_location";
    permissions << "friends_location";
    permissions << "user_hometown";
    permissions << "friends_hometown";
    permissions << "user_activities";
    permissions << "friends_activities";
    permissions << "friends_status";
    permissions << "user_videos";
    permissions << "friends_videos";
    permissions << "read_friendlists";
    permissions << "read_requests";
    permissions << "xmpp_login";
    permissions << "user_likes";
    permissions << "friends_likes";
    permissions << "manage_notifications";

    return permissions;
}
