#include "facebookbrowser.h"
#include "ui_facebookbrowser.h"

FacebookBrowser::FacebookBrowser(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::FacebookBrowser)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);

    WebPage *page = new WebPage(ui->webView);
    ui->webView->setPage(page);

    QString cookieDir = QDesktopServices::storageLocation(QDesktopServices::DataLocation);
    QDir dir = QDir(cookieDir);
    if (!dir.exists())
        dir.mkpath(cookieDir);
    QString cookieFile = cookieDir + "/facebook.cookies";
    CookieJar *cookieJar = new CookieJar(cookieFile);
    ui->webView->page()->networkAccessManager()->setCookieJar(cookieJar);

    connect(ui->webView, SIGNAL(loadProgress(int)), ui->progressBar, SLOT(setValue(int)));
    connect(ui->actionBack, SIGNAL(triggered()), ui->webView, SLOT(back()));
    connect(ui->actionForward, SIGNAL(triggered()), ui->webView, SLOT(forward()));
    connect(ui->actionRefresh, SIGNAL(triggered()), ui->webView, SLOT(reload()));
    connect(ui->stopButton, SIGNAL(clicked()), ui->webView, SLOT(stop()));
    connect(ui->webView, SIGNAL(loadStarted()), this, SLOT(onLoadStarted()));
    connect(ui->webView, SIGNAL(loadFinished(bool)), this, SLOT(onLoadFinished(bool)));

#ifdef Q_WS_MAEMO_5
    ui->stopButton->setText("");
    ui->stopButton->setIcon(QIcon::fromTheme("general_stop"));
    setAttribute(Qt::WA_Maemo5StackedWindow);
    QWebViewSelectionSuppressor *suppressor = new QWebViewSelectionSuppressor(ui->webView);
    suppressor->enable();
#endif
}

FacebookBrowser::~FacebookBrowser()
{
    delete ui;
}

void FacebookBrowser::openPage(FacebookBrowser::FacebookPages page)
{
    QString url;
    switch (page) {
    case FacebookBrowser::FacebookAccountSettings:
        url = "https://www.facebook.com/editaccount.php";
        break;
    case FacebookBrowser::FacebookPrivacySettings:
        url = "https://www.facebook.com/settings/?tab=privacy";
        break;
    case FacebookBrowser::FacebookHelpCenter:
        url = "https://www.facebook.com/help/";
        break;
    }
    ui->webView->setUrl(QUrl(url));
}

void FacebookBrowser::openPage(QString url)
{
    ui->webView->setUrl(QUrl(url));
}

void FacebookBrowser::onLoadStarted()
{
    ui->widget->show();
}

void FacebookBrowser::onLoadFinished(bool)
{
    ui->widget->hide();
}

QWebView* FacebookBrowser::webView()
{
    return ui->webView;
}

WebPage::WebPage(QWebView *parent) :
    QWebPage(parent)
{}

QString WebPage::userAgentForUrl(const QUrl &url) const
{
#ifdef Q_WS_MAEMO_5
    Q_UNUSED(url)
    return QString("Firefox/3.5 Maemo Browser 1.7.4.8 RX-51 N900");
#else
    return QWebPage::userAgentForUrl(url);
#endif
}
