#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "systemnotification.h"

SystemNotification *notifier = 0;

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
#ifndef Q_WS_MAEMO_5
    ui->hideOnExitBox->hide();
#endif
    setAttribute(Qt::WA_DeleteOnClose);
    notifier = new SystemNotification(this);
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    this->orientationChanged();
    this->loadSettings();
    // Supported OS, remove confusing text
#ifdef Q_WS_MAEMO_5
    ui->guiNotifyBox->setText(tr("GUI Notifications"));
#endif
    connect(ui->volumeSlider, SIGNAL(sliderReleased()), this, SLOT(onVolumeSliderReleased()));
    connect(ui->notificationFileButton, SIGNAL(clicked()), this, SLOT(onNotificationFileButtonClicked()));
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::loadSettings()
{
    if (QSettings().contains("main/refresh-interval")) {
        int refreshInterval = QSettings().value("main/refresh-interval").toInt();
        if (refreshInterval != 0)
            ui->refreshEdit->setText(QString::number(refreshInterval/1000/60));
        else
            ui->refreshEdit->setText("0");
    }
    ui->vibraSpeedSlider->setValue(QSettings().value("vibration/notification-speed", 150).toInt());
    ui->vibraDurationSlider->setValue(QSettings().value("vibration/notification-duration", 200).toInt());
    ui->guiNotifyBox->setChecked(QSettings().value("main/gui-notifications", true).toBool());
    ui->volumeSlider->setValue(QSettings().value("main/notifications-volume", 100).toInt());
#ifdef Q_WS_MAEMO_5
    m_soundFilename = QSettings().value("main/notifications-soundfile", "/opt/usr/share/sociality/notification.wav").toString();
    ui->hideOnExitBox->setChecked(QSettings().value("main/hide-on-exit", false).toBool());
#else
    m_soundFilename = QSettings().value("main/notifications-soundfile").toString();
#endif
    if (!m_soundFilename.isEmpty())
        ui->notificationFileButton->setText(m_soundFilename);
}

void SettingsDialog::saveSettings()
{
    int refreshInterval = ui->refreshEdit->text().toInt();
    if (refreshInterval != QSettings().value("main/refresh-interval").toInt()*60*1000) {
        if (refreshInterval == 0)
            QSettings().setValue("main/refresh-interval", refreshInterval);
        else
            QSettings().setValue("main/refresh-interval", refreshInterval*60*1000);
    }
    QSettings().setValue("vibration/notification-speed", ui->vibraSpeedSlider->value());
    QSettings().setValue("vibration/notification-duration", ui->vibraDurationSlider->value());
    QSettings().setValue("main/gui-notifications", ui->guiNotifyBox->isChecked());
    QSettings().setValue("main/notifications-volume", ui->volumeSlider->value());
    QSettings().setValue("main/notifications-soundfile", m_soundFilename);
#ifdef Q_WS_MAEMO_5
    QSettings().setValue("main/hide-on-exit", ui->hideOnExitBox->isChecked());
#endif
}

void SettingsDialog::onVolumeSliderReleased()
{
    notifier->createSoundNotification(ui->volumeSlider->value());
}

void SettingsDialog::accept()
{
    this->saveSettings();
    this->close();
}

void SettingsDialog::orientationChanged()
{
    ui->mainLayout->removeWidget(ui->buttonBox);
    if (QApplication::desktop()->screenGeometry().width() > QApplication::desktop()->screenGeometry().height()) {
        ui->buttonBox->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Minimum));
        ui->mainLayout->addWidget(ui->buttonBox, 0, 1, 1, 1);
        this->setMinimumHeight(365);
    } else {
        ui->buttonBox->setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum));
        ui->mainLayout->addWidget(ui->buttonBox, 1, 0, 1, ui->mainLayout->columnCount(), Qt::AlignBottom);
        this->setMinimumHeight(500);
    }
}

void SettingsDialog::onNotificationFileButtonClicked()
{
    QString fileName = QFileDialog::getOpenFileName(this, "Select notification sound", QDir::homePath());
    if ((!m_soundFilename.isEmpty() && fileName != m_soundFilename && !fileName.isEmpty()) || !fileName.isEmpty()) {
        m_soundFilename = fileName;
        ui->notificationFileButton->setText(m_soundFilename);
    }
}
