#ifndef NOTIFICATIONSDIALOG_H
#define NOTIFICATIONSDIALOG_H

#include <QDialog>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QXmlStreamReader>
#include <QMap>
#include <QDebug>
#include <QList>
#include <QMessageBox>
#include <QTimer>
#include <qfacebook.h>
#include <QDesktopWidget>
#include <qjson/serializer.h>
#include "widgets/notificationitem.h"
#include "profilewindow.h"
#include "singlepostwindow.h"
#include "albumswindow.h"

namespace Ui {
    class NotificationsDialog;
}

class NotificationsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit NotificationsDialog(QWidget *parent = 0, QString token = "0");
    ~NotificationsDialog();

public slots:
    void updateNotifications();
    void getNoficiationCount();

protected:
    void showEvent(QShowEvent *);

signals:
    void gotNotificationsCount(int count);
    void gotNotificationsList(QVariantMap);

private:
    Ui::NotificationsDialog *ui;
    QString accessToken;
    QXmlStreamReader xml;
    QNetworkAccessManager* nam;
    QNetworkReply *reply;
    QNetworkReply *countReply;
    QNetworkReply *markReadReply;
    QFacebook *qfacebook;
    QMap <QString, QString> parseNotification(QXmlStreamReader &xml);
    QByteArray m_notifications;
    void addElementDataToMap(QXmlStreamReader& xml, QMap<QString, QString>& map) const;
    void addNotificationsToUi(QList< QMap<QString,QString> >& notifications);
    QList <NotificationItem*> notificationItems;
    int unreadCount;
    bool isFetching;
    QList <NotificationItem*> m_unreadNotifications;

private slots:
    void onNotificationsListReceived();
    void onGotNotificationsCount();
    void orientationChanged();
    void onNotificationClicked(NotificationItem*);
    void markRead();
    void onMarkedAsRead(NotificationItem *item);
};

#endif // NOTIFICATIONSDIALOG_H
