#include "newnotedialog.h"
#include "ui_newnotedialog.h"
#include "friendswindow.h"

NewNoteDialog::NewNoteDialog(QWidget *parent, QString token) :
    QDialog(parent),
    ui(new Ui::NewNoteDialog),
    accessToken(token)
{
    ui->setupUi(this);
    ui->horizontalWidget->hide();
    connect(ui->friendWallRadio, SIGNAL(clicked()), this, SLOT(onFriendRadioClicked()));
}

NewNoteDialog::~NewNoteDialog()
{
    delete ui;
}

void NewNoteDialog::accept()
{
    if (ui->myWallRadio->isChecked())
        m_userId = "me";
    emit createNote(ui->lineEdit->text(), "me");
}

void NewNoteDialog::onFriendRadioClicked()
{
    FriendsWindow *friends = new FriendsWindow(this, accessToken);
    connect(friends, SIGNAL(recepientsSelected(QList<QListWidgetItem*>)), this, SLOT(onRecepientsSelected(QList<QListWidgetItem*>)));
    friends->requestFriend();
}

void NewNoteDialog::onRecepientsSelected(QList<QListWidgetItem*> list)
{
    m_userId = list.first()->data(Qt::UserRole).toString();
    sender()->deleteLater();
}
