#include "messageview.h"
#include "ui_messageview.h"
#include "profilewindow.h"

MessageView::MessageView(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::MessageView),
    accessToken(token),
    qfacebook(new QFacebook(token, this)),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    ui->replyButton->setMinimumHeight(ui->replyText->sizeHint().height());
    myId = QSettings().value("main/myId").toString();
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    bool whiteMode = QSettings().value("main/white-mode", false).toBool();
    if (whiteMode) {
        QPalette p(palette());
        p.setColor(QPalette::Background, QColor(220, 225, 235));
        setPalette(p);
    }
}

MessageView::~MessageView()
{
    delete ui;
}

void MessageView::parseMessageById(QString id)
{
    this->reply = qfacebook->getObject(id);
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
}

void MessageView::onReplyReceived()
{
    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch messages!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    foreach (NewsFeedPost *reply, messages) {
        ui->repliesLayout->removeWidget(reply);
        messages.removeOne(reply);
        delete reply;
    }

    QVariant jsonData = this->reply->data();
    NewsFeedPost *mainMessage = new NewsFeedPost(this, accessToken, qfacebook, nam);
    connect(mainMessage, SIGNAL(nameClicked(QString,QString)), this, SLOT(onNameClicked(QString,QString)));
    QString from = jsonData.toMap().value("from").toMap().value("name").toString();
    QString fromId = jsonData.toMap().value("from").toMap().value("id").toString();
    QString message = jsonData.toMap().value("message").toString();
    QDateTime time = QDateTime::fromString(jsonData.toMap().value("updated_time").toString(), Qt::ISODate);
    QString sentTime = QString(time.toString("dddd, MMMM d %1 hh:mmap").arg(tr("at")));
    this->setWindowTitle(this->windowTitle() + " " + tr("with") + " " + from);

    mainMessage->setMessageMode(true);
    mainMessage->setUserId(fromId);
    mainMessage->setName(from);
    mainMessage->setMessage(message);
    mainMessage->setTimeFromString(sentTime);
    mainMessage->getPixmapFromUrl(QString("http://graph.facebook.com/%1/picture").arg(fromId));

    ui->mainMessageLayout->addWidget(mainMessage);

    QVariantList listData;
    listData = jsonData.toMap().value("comments").toMap().value("data").toList();
    foreach(jsonData, listData) {
        NewsFeedPost *post = new NewsFeedPost(ui->repliesWidget, accessToken, qfacebook, nam);
        connect(post, SIGNAL(nameClicked(QString,QString)), this, SLOT(onNameClicked(QString,QString)));
        post->setMessageMode(true);
        QString name = jsonData.toMap().value("from").toMap().value("name").toString();
        QString userId = jsonData.toMap().value("from").toMap().value("id").toString();
        /* Messages are read-only */
        //  if (userId == myId)
        //    post->setDeletable(true);
        QString message = jsonData.toMap().value("message").toString();
        QString link = jsonData.toMap().value("link").toString();
        if (link.isEmpty())
            link = jsonData.toMap().value("source").toString();
        if (!link.isEmpty()) {
            post->addLink(link,
                          jsonData.toMap().value("name").toString(),
                          jsonData.toMap().value("description").toString(),
                          jsonData.toMap().value("picture").toString());
        }

        QDateTime time = QDateTime::fromString(jsonData.toMap().value("created_time").toString(), Qt::ISODate);
        QString sentTime = QString(time.toString("dddd, MMMM d %1 hh:mmap")).arg(tr("at"));

        post->setName(name);
        post->setMessage(message);
        post->setId(jsonData.toMap().value("id").toString());
        post->getPixmapFromUrl(QString("http://graph.facebook.com/%1/picture").arg(userId));
        post->setTimeFromString(sentTime);
        messages.append(post);
        ui->repliesLayout->addWidget(post);
    }
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void MessageView::onNameClicked(QString id, QString name)
{
    ProfileWindow *profile = new ProfileWindow(this, accessToken);
    profile->browseProfile(id);
    profile->setWindowTitle(name);
#ifdef Q_WS_S60
    profile->showMaximized();
#else
    profile->show();
#endif
}
