#ifndef FRIENDSWINDOW_H
#define FRIENDSWINDOW_H

#include <QMainWindow>
#include <QStringList>
#include <QPushButton>
#include <QDebug>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QKeyEvent>
#include <QSettings>
#include <QListWidgetItem>
#include <QThread>
#include <qjson/parser.h>
#include "profilewindow.h"
#include "loginwindow.h"
#include "facebookbrowser.h"
#include <qfacebook.h>

#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#else
    #include <QMessageBox>
#endif

namespace Ui {
    class FriendsWindow;
}

class FriendsWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit FriendsWindow(QWidget *parent = 0, QString accessToken = "0");
    ~FriendsWindow();
    void browseId(QString id);
    void setToken(QString token);
    void requestRecepientsList();
    void requestFriend();
    QString m_cacheLocation;

protected:
    void keyReleaseEvent(QKeyEvent *);

signals:
    void recepientsSelected(QList<QListWidgetItem*>);

private:
    Ui::FriendsWindow *ui;
    QString token;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QFacebookReply *pagesReply;
    QNetworkReply *requestsReply;
    QString idToBrowse;
    QNetworkAccessManager *nam;
    FacebookBrowser *browser;
    bool m_isDialog;
    bool m_shouldFetchAvatars;
    bool m_isRequestingFriendList;
    void parseData(QVariant jsonData);
    QVariant m_friendsList;
    // Workaround for unticked friends
    QStringList m_checkedIdList;
    void processCheckedList();

private slots:
    void onReplyFinished();
    void onAvatarReplyFinished(QNetworkReply *reply);
    void onAvatarProcessed(QString id, QImage image);
    void onRecepientsSelected();
    void onFriendClicked(QListWidgetItem*);
    void updateFriends();
    void onSearchTextChanged(QString);
    void onItemParsed(QListWidgetItem*);
    void onStackedWidgetCurrentChanged(int);
    void getPagesList();
    void onGotPagesList();
    void getFriendRequests();
    void onRadioButtonClicked(bool);
    void onGotFriendRequests();
    void onGotNameReply();
    void onRequestClicked(QListWidgetItem*);
    void onUrlChanged(QUrl url);
    void refresh();
    void onRequestAvatarProcessed(QString id, QImage image);
    void onPageClicked(QListWidgetItem*);
};

class FriendParser : public QObject
{
    Q_OBJECT

public:
    explicit FriendParser(QVariant jsonData, bool isDialog = false, bool shouldFetchAvatars = true);

public slots:
    void start();

signals:
    void finished();
    void itemParsed(QListWidgetItem*);
    void avatarReceived(QString id, QImage image);

private:
    QVariant m_jsonData;
    QNetworkAccessManager *nam;
    bool m_isDialog;
    bool m_shouldFetchAvatars;

private slots:
    void onAvatarProcessed(QString id, QImage avatar);
};

class Friend : public QObject
{
    Q_OBJECT

public:
    explicit Friend(QWidget *parent = 0, QString id = "0");
    ~Friend();

signals:
    void avatarProcessed(QString, QImage);

public slots:
    void avatarReceived();

private:
    QString userId;
};

#endif // FRIENDSWINDOW_H
