#include "chatconversationwindow.h"
#include "ui_chatconversationwindow.h"

ChatConversationWindow::ChatConversationWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::ChatConversationWindow)
{
    ui->setupUi(this);
    connect(ui->pushButton, SIGNAL(clicked()), this, SLOT(sendMessage()));
    connect(ui->lineEdit, SIGNAL(returnPressed()), this, SLOT(sendMessage()));
    ui->scrollAreaWidgetContents->setMaximumWidth(this->width());
}

ChatConversationWindow::~ChatConversationWindow()
{
    delete ui;
}

QString ChatConversationWindow::getBareJid() const
{
    return m_bareJid;
}

QString ChatConversationWindow::getDisplayName() const
{
    return m_displayName;
}

void ChatConversationWindow::setBareJid(const QString &bareJid)
{
    m_bareJid = bareJid;
}

void ChatConversationWindow::setDisplayName(const QString &name)
{
    m_displayName = name;
    setWindowTitle(QString("Chat with %1").arg(name));
}

void ChatConversationWindow::setQXmppClient(QXmppClient *client)
{
    m_qxmppClient = client;
}

void ChatConversationWindow::addMessage(QString name, QString message, QPixmap avatar)
{
    ChatMessageItem *item = new ChatMessageItem(this);
    item->setName(name);
    item->setMessage(message.replace(QRegExp("((?:https?|ftp)://\\S+)"), "<a href=\"\\1\">\\1</a>"));
    item->setAvatar(avatar);

    messagesList.append(item);
    ui->messagesLayout->addWidget(item);

    if (!ui->scrollArea->horizontalScrollBar()->isSliderDown())
        ui->scrollAreaWidgetContents->scroll(0, ui->scrollAreaWidgetContents->maximumHeight());
}

void ChatConversationWindow::sendMessage()
{
    if (ui->lineEdit->text().isEmpty())
        return;

    if (m_qxmppClient)
        m_qxmppClient->sendMessage(getBareJid(), ui->lineEdit->text());

    addMessage("You", ui->lineEdit->text());
    ui->lineEdit->clear();
}

void ChatConversationWindow::messageReceived(const QString &message)
{
    addMessage(getDisplayName(), message);
}

void ChatConversationWindow::resizeEvent(QResizeEvent *e)
{
    ui->scrollAreaWidgetContents->setMaximumWidth(this->width());
    QMainWindow::resizeEvent(e);
}
