#include "videowidget.h"

VideoWidget::VideoWidget(QWidget *parent) :
    QVideoWidget(parent)
{
}

void VideoWidget::mousePressEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = true;
        emit pressed();
    }
}

void VideoWidget::mouseReleaseEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = false;
        emit released();
        if (rect().contains(ev->pos())) {
            emit clicked();
        }
    }
}

bool VideoWidget::isPressed()
{
    return m_pressed;
}

void VideoWidget::mouseDoubleClickEvent(QMouseEvent *)
{
    emit doubleClicked();
}
