#include "progressdialog.h"
#include "ui_progressdialog.h"

ProgressDialog::ProgressDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::ProgressDialog)
{
    ui->setupUi(this);
}

ProgressDialog::~ProgressDialog()
{
    delete ui;
}

void ProgressDialog::showProgress(QString name, int percentage)
{
    ProgressItem *item;
    if (!uploadNames.contains(name)) {
        item = new ProgressItem(this, name);
        item->progressBar()->setMaximumWidth(this->width()*0.60);
        ui->scrollLayout->addWidget(item);
        progressMap.insert(name, item);
        uploadNames.append(name);
    } else {
        item = progressMap.value(name);
    }
    item->progressBar()->setValue(percentage);
}

void ProgressDialog::resizeEvent(QResizeEvent *e)
{
    foreach (ProgressItem *item, progressMap.values()) {
        item->progressBar()->setMaximumWidth(this->width()*0.60);
    }

    QDialog::resizeEvent(e);
}
