#ifndef NOTESWINDOW_H
#define NOTESWINDOW_H

#include <QMainWindow>
#include <QDebug>
#include <QListWidgetItem>
#include <qfacebook.h>

#include "notewindow.h"
#include "newnotedialog.h"

namespace Ui {
    class NotesWindow;
}

class NotesWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit NotesWindow(QWidget *parent = 0, QString accessToken = "0");
    ~NotesWindow();
    void browseNotes(QString userId);

public slots:
    void refreshNotes();

private:
    Ui::NotesWindow *ui;
    QString accessToken;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QString m_userId;

private slots:
    void onReplyReceived();
    void onItemActivated(QListWidgetItem *item);
    void onCreateNote(QString subject, QString id);
    void createNote();
};

#endif // NOTESWINDOW_H
