#ifndef THUMBNAILITEMDELEGATE_H
#define THUMBNAILITEMDELEGATE_H

#include <QObject>
#include <QPainter>
#include <QRect>
#include <QModelIndex>
#include <QString>
#include <QFont>
#include <QColor>
#include <QStyledItemDelegate>
#include <QDesktopServices>
#include <QDesktopWidget>
#include <QApplication>
#include <QStyleOptionViewItem>
#include <QPainterPath>
#include <QBrush>
#include <QDebug>

enum DisplayRoles {UserRoleValueText,
                   UserRoleUserId};

class ThumbnailItemDelegate : public QStyledItemDelegate
{
public:
    explicit ThumbnailItemDelegate(QObject *parent=0) : QStyledItemDelegate(parent) {}
    virtual ~ThumbnailItemDelegate() {}
    void paint (QPainter* painter, const QStyleOptionViewItem& option, const QModelIndex& index) const;
    QSize sizeHint(const QStyleOptionViewItem& option, const QModelIndex& index) const;

private:
    void drawBadge(QPainter *painter, int x, int y, int size, QString text, QBrush brush) const;
    void fillEllipse(QPainter *painter, int x, int y, int size, QBrush brush) const;
};

#endif // THUMBNAILITEMDELEGATE_H
