#ifndef CHATWINDOW_H
#define CHATWINDOW_H

#include <QMainWindow>
#include <QDebug>
#include <qxmpp/QXmppClient.h>
#include <qxmpp/QXmppMessage.h>
#include <qxmpp/QXmppConfiguration.h>
#include <qxmpp/QXmppRosterManager.h>
#include <qxmpp/QXmppLogger.h>
#include "qxmpp/QXmppUtils.h"
#include <qxmpp/QXmppVCardManager.h>
#include <QMessageBox>
#include <QSettings>
#include <QTimer>
#include "chat/vCardCache.h"
#include "chat/rosterItem.h"
#include "chat/rosterItemModel.h"
#include "chat/rosterListView.h"
#include "chat/rosterItemSortFilterProxyModel.h"
#include "chat/capabilitiesCache.h"
#include "chat/chatlogindialog.h"
#include "chat/chatconversationwindow.h"

namespace Ui {
    class ChatWindow;
}

class ChatWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit ChatWindow(QWidget *parent = 0);
    ~ChatWindow();

private:
    Ui::ChatWindow *ui;
    QXmppClient *m_xmppClient;
    vCardCache *m_vCardCache;
    rosterItemModel *m_rosterItemModel;
    capabilitiesCache m_capabilitiesCache;
    QString m_username;
    QMap<QString, ChatConversationWindow*> m_conversationWindows;
    rosterItemSortFilterProxyModel *m_rosterItemSortFilterModel;
    ChatConversationWindow* getChatWindow(const QString &);

private slots:
    void onPresenceReceived(QXmppPresence presence);
    void presenceChanged(QString bareJid, QString resource);
    void rosterReceived();
    void rosterChanged(QString bareJid);
    void updateVCard(QString bareJid);
    void onLoginClicked(QString username, QString password, bool save);
    void onMessageReceived(QXmppMessage message);
    void showChatWindow(const QString &);
    void goOffline();
};

#endif // CHATWINDOW_H
