#ifndef ALBUMSWINDOW_H
#define ALBUMSWINDOW_H

#include <QMainWindow>
#include <QDebug>
#include <QNetworkAccessManager>
#include "newalbumdialog.h"
#include "albumwindow.h"
#include <qfacebook.h>

namespace Ui {
    class AlbumsWindow;
}

class AlbumsWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit AlbumsWindow(QWidget *parent = 0, QString token = "0");
    ~AlbumsWindow();
    void browseAlbums(QString userId);

private:
    Ui::AlbumsWindow *ui;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QFacebookReply *albumCreationReply;
    QNetworkAccessManager *nam;
    QString accessToken;
    QString m_userId;

private slots:
    void onReplyReceived();
    void updateAlbums();
    void onNewAlbumClicked();
    void createAlbum(QString, QString, QString);
    void onAlbumCreationReply();
    void onCoverImageProcessed(QString id, QPixmap pixmap);
    void onAlbumClicked(QListWidgetItem *item);
};

class AlbumItem : public QObject
{
    Q_OBJECT

public:
    explicit AlbumItem(QWidget *parent = 0, QString id = "0");
    ~AlbumItem();

signals:
    void coverImageProcessed(QString, QPixmap);

public slots:
    void coverReceived();

private:
    QString userId;
};

#endif // ALBUMSWINDOW_H
