#ifndef CHECKINDIALOG_H
#define CHECKINDIALOG_H

#include <QDialog>
#include <QDebug>
#include <QDesktopWidget>
#include <qfacebook.h>

namespace Ui {
    class CheckinDialog;
}

enum UserRoles {UserRoleName=Qt::UserRole,
                LocationId,
                Longitude,
                Latitude};

class CheckinDialog : public QDialog
{
    Q_OBJECT

public:
    explicit CheckinDialog(QWidget *parent = 0, QString token = "0");
    ~CheckinDialog();

public slots:
    void setCoordinates(double longitude, double latitude);

signals:
    void placeSelected(QString name, QString id, QString longitude, QString latitude);

private:
    Ui::CheckinDialog *ui;
    double m_longitude;
    double m_latitude;
    QString accessToken;
    QString m_locationString;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QVariant m_locations;

private slots:
    void refreshPlaces();
    void onReplyReceived();
    void accept();
    void orientationChanged();
};

#endif // CHECKINDIALOG_H
