#include "placeitem.h"
#include "ui_placeitem.h"
#include "profilewindow.h"

PlaceItem::PlaceItem(QWidget *parent, QString token, QNetworkAccessManager *nam) :
    QWidget(parent),
    ui(new Ui::PlaceItem),
    accessToken(token),
    nam(nam)
{
    ui->setupUi(this);
    QPalette p = this->palette();
    p.setColor(QPalette::Foreground, p.highlight().color());
    ui->nameLabel->setPalette(p);

    bool whiteMode = QSettings().value("main/white-mode", false).toBool();
    if (whiteMode) {
        p.setColor(QPalette::Foreground, Qt::black);
        ui->locationLabel->setPalette(p);
        ui->timeLabel->setPalette(p);
    }
    connect(ui->nameLabel, SIGNAL(clicked()), this, SLOT(onNameClicked()));
}

PlaceItem::~PlaceItem()
{
    delete ui;
}

void PlaceItem::setName(QString name)
{
    ui->nameLabel->setText(name);
}

void PlaceItem::setLocation(QString location)
{
    ui->locationLabel->setText(location);
}

void PlaceItem::setTime(QString time)
{
    ui->timeLabel->setText(time);
}

void PlaceItem::setPlaceId(QString id)
{
    m_placeId = id;
}

void PlaceItem::setUserId(QString id)
{
    m_userId = id;
}

void PlaceItem::setCoordinates(double longitude, double latitude)
{
    m_longitude = longitude;
    m_latitude = latitude;
}

void PlaceItem::setCheckinId(QString id)
{
    m_checkinId = id;
}

void PlaceItem::setAvatarUrl(QString url)
{
    avatarReply = nam->get(QNetworkRequest(url));
    if (avatarReply)
        connect(avatarReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));
}

void PlaceItem::onAvatarReceived()
{
    QUrl redir = avatarReply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        avatarReply->deleteLater();
        avatarReply = nam->get(QNetworkRequest(redir));

        connect(avatarReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));
        return;
    }
    ui->avatarLabel->setPixmap(QPixmap::fromImage(QImage::fromData(avatarReply->readAll())));
    avatarReply->deleteLater();
}

void PlaceItem::mousePressEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = true;
        emit pressed();
    }
}

void PlaceItem::mouseReleaseEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = false;
        emit released();
        if (rect().contains(ev->pos())) {
            emit clicked(m_checkinId);
        }
    }
}

void PlaceItem::onNameClicked()
{
    ProfileWindow *profile = new ProfileWindow(this->parentWidget(), accessToken);
    profile->browseProfile(m_userId);
    profile->setWindowTitle(ui->nameLabel->text());
#ifdef Q_WS_S60
    profile->showMaximized();
#else
    profile->show();
#endif
}

bool PlaceItem::isPressed()
{
    return m_pressed;
}

void PlaceItem::paintEvent(QPaintEvent *)
{
#if 0
    QPainter painter(this);
    QPen pen = painter.pen();
    pen.setColor(this->palette().highlight().color());
    painter.setPen(pen);
    qDebug() << QPoint(this->geometry().left(), this->geometry().bottom());
    qDebug() << QPoint(this->geometry().right() ,this->geometry().bottom());
    painter.drawLine(QPoint(this->geometry().left(), this->geometry().bottom()),
                     QPoint(this->geometry().right() ,this->geometry().bottom()));
#endif
}
